/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.PseudoPage;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.StyleReference;
import org.pentaho.reporting.libraries.css.model.CSSCounterRule;
import org.pentaho.reporting.libraries.css.model.CSSPageRule;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.namespace.NamespaceCollection;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.css.resolver.StyleRuleMatcher;
import org.pentaho.reporting.libraries.css.selectors.CSSSelector;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SimpleStyleRuleMatcher
implements StyleRuleMatcher {
    private DocumentContext layoutProcess;
    private ResourceManager resourceManager;
    private CSSStyleRule[] activeStyleRules;
    private CSSStyleRule[] activePseudoStyleRules;
    private CSSPageRule[] pageRules;
    private CSSCounterRule[] counterRules;
    private NamespaceCollection namespaces;

    @Override
    public void initialize(DocumentContext layoutProcess) {
        int i;
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.resourceManager = layoutProcess.getResourceManager();
        ArrayList pageRules = new ArrayList();
        ArrayList counterRules = new ArrayList();
        ArrayList<CSSStyleRule> styleRules = new ArrayList<CSSStyleRule>();
        DocumentContext dc = this.layoutProcess;
        this.namespaces = dc.getNamespaces();
        String[] nsUri = this.namespaces.getNamespaces();
        for (int i2 = 0; i2 < nsUri.length; ++i2) {
            ResourceKey baseKey;
            StyleSheet styleSheet;
            String uri = nsUri[i2];
            NamespaceDefinition nsDef = this.namespaces.getDefinition(uri);
            ResourceKey rawKey = nsDef.getDefaultStyleSheetLocation();
            if (rawKey == null || (styleSheet = this.parseStyleSheet(rawKey, baseKey = layoutProcess.getContextKey())) == null) continue;
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        StyleReference[] refs = dc.getStyleReferences();
        for (i = 0; i < refs.length; ++i) {
            StyleReference ref = refs[i];
            if (ref.getType() == 0) {
                this.handleLinkNode(dc, ref, styleRules, pageRules, counterRules);
                continue;
            }
            this.handleStyleNode(dc, ref, styleRules, pageRules, counterRules);
        }
        this.activeStyleRules = styleRules.toArray(new CSSStyleRule[styleRules.size()]);
        this.pageRules = pageRules.toArray(new CSSPageRule[pageRules.size()]);
        this.counterRules = counterRules.toArray(new CSSCounterRule[counterRules.size()]);
        styleRules.clear();
        for (i = 0; i < this.activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = this.activeStyleRules[i];
            if (!this.isPseudoElementRule(activeStyleRule)) continue;
            styleRules.add(activeStyleRule);
        }
        this.activePseudoStyleRules = styleRules.toArray(new CSSStyleRule[styleRules.size()]);
    }

    private void handleLinkNode(DocumentContext context, StyleReference node, ArrayList styleRules, ArrayList pageRules, ArrayList counterRules) {
        try {
            String href = node.getStyleContent();
            ResourceKey baseKey = context.getContextKey();
            ResourceKey derivedKey = baseKey == null ? this.resourceManager.createKey((Object)href) : this.resourceManager.deriveKey(baseKey, String.valueOf(href));
            StyleSheet styleSheet = this.parseStyleSheet(derivedKey, null);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        catch (ResourceKeyCreationException e) {
            e.printStackTrace();
        }
    }

    private void handleStyleNode(DocumentContext context, StyleReference node, ArrayList styleRules, ArrayList pageRules, ArrayList counterRules) {
        String styleText = node.getStyleContent();
        try {
            byte[] bytes = styleText.getBytes("UTF-8");
            ResourceKey rawKey = this.resourceManager.createKey((Object)bytes);
            ResourceKey baseKey = context.getContextKey();
            StyleSheet styleSheet = this.parseStyleSheet(rawKey, baseKey);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, styleRules);
            this.addPageRules(styleSheet, pageRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ResourceKeyCreationException e) {
            e.printStackTrace();
        }
    }

    private void addCounterRules(StyleSheet styleSheet, ArrayList rules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addCounterRules(styleSheet.getStyleSheet(i), rules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSCounterRule)) continue;
            CSSCounterRule drule = (CSSCounterRule)rule;
            rules.add(drule);
        }
    }

    private void addPageRules(StyleSheet styleSheet, ArrayList rules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addPageRules(styleSheet.getStyleSheet(i), rules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSPageRule)) continue;
            CSSPageRule drule = (CSSPageRule)rule;
            rules.add(drule);
        }
    }

    private void addStyleRules(StyleSheet styleSheet, ArrayList activeStyleRules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addStyleRules(styleSheet.getStyleSheet(i), activeStyleRules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            StyleRule rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSStyleRule)) continue;
            CSSStyleRule drule = (CSSStyleRule)rule;
            activeStyleRules.add(drule);
        }
    }

    private StyleSheet parseStyleSheet(ResourceKey key, ResourceKey context) {
        try {
            Resource resource = this.resourceManager.create(key, context, StyleSheet.class);
            return (StyleSheet)resource.getResource();
        }
        catch (ResourceException resourceException) {
            return null;
        }
    }

    private boolean isPseudoElementRule(CSSStyleRule rule) {
        CSSSelector selector = rule.getSelector();
        if (selector == null) {
            return false;
        }
        if (selector.getSelectorType() != 0) {
            return false;
        }
        ConditionalSelector cs = (ConditionalSelector)selector;
        Condition condition = cs.getCondition();
        return condition.getConditionType() == 10;
    }

    @Override
    public boolean isMatchingPseudoElement(LayoutElement element, String pseudo) {
        for (int i = 0; i < this.activePseudoStyleRules.length; ++i) {
            SimpleSelector simpleSelector;
            CSSStyleRule activeStyleRule = this.activePseudoStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            ConditionalSelector cs = (ConditionalSelector)selector;
            Condition condition = cs.getCondition();
            AttributeCondition ac = (AttributeCondition)condition;
            if (!ObjectUtilities.equal((Object)ac.getValue(), (Object)pseudo) || !this.isMatch(element, (Selector)(simpleSelector = cs.getSimpleSelector()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public StyleRuleMatcher deriveInstance() {
        return this;
    }

    @Override
    public CSSStyleRule[] getMatchingRules(LayoutElement element) {
        ArrayList<CSSStyleRule> retvals = new ArrayList<CSSStyleRule>();
        for (int i = 0; i < this.activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = this.activeStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            if (selector == null || !this.isMatch(element, selector)) continue;
            retvals.add(activeStyleRule);
        }
        return retvals.toArray(new CSSStyleRule[retvals.size()]);
    }

    private boolean isMatch(LayoutElement node, Selector selector) {
        short selectorType = selector.getSelectorType();
        switch (selectorType) {
            case 1: {
                return true;
            }
            case 2: {
                return node.getParentLayoutElement() == null;
            }
            case 3: {
                NegativeSelector negativeSelector = (NegativeSelector)selector;
                return !this.isMatch(node, (Selector)negativeSelector);
            }
            case 12: {
                SiblingSelector silbSelect = (SiblingSelector)selector;
                return this.isSilblingMatch(node, silbSelect);
            }
            case 9: {
                return node.isPseudoElement();
            }
            case 4: {
                ElementSelector es = (ElementSelector)selector;
                String localName = es.getLocalName();
                if (localName != null && !localName.equals(node.getTagName())) {
                    return false;
                }
                String namespaceURI = es.getNamespaceURI();
                if (namespaceURI != null) {
                    return this.containsNamespace(namespaceURI, this.layoutProcess.getNamespaces());
                }
                return true;
            }
            case 11: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                LayoutElement parent = node.getParentLayoutElement();
                return this.isMatch(parent, ds.getAncestorSelector());
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                return this.isDescendantMatch(node, ds.getAncestorSelector());
            }
            case 0: {
                ConditionalSelector cs = (ConditionalSelector)selector;
                if (!this.evaluateCondition(node, cs.getCondition())) {
                    return false;
                }
                return this.isMatch(node, (Selector)cs.getSimpleSelector());
            }
        }
        return false;
    }

    private boolean containsNamespace(String namespaceURI, NamespaceCollection namespaces) {
        if (namespaces == null || namespaceURI == null) {
            return false;
        }
        String[] namespaceStrings = namespaces.getNamespaces();
        for (int i = 0; i < namespaceStrings.length; ++i) {
            if (!namespaceURI.equals(namespaceStrings[i])) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateCondition(LayoutElement node, Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) && this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 1: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) || this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 4: {
                AttributeCondition ac = (AttributeCondition)condition;
                String namespaceURI = ac.getNamespaceURI();
                if (namespaceURI == null) {
                    namespaceURI = node.getNamespace();
                }
                Object attr = node.getAttribute(namespaceURI, ac.getLocalName());
                if (ac.getValue() == null) {
                    return attr != null;
                }
                return ObjectUtilities.equal((Object)attr, (Object)ac.getValue());
            }
            case 9: {
                AttributeCondition ac = (AttributeCondition)condition;
                String namespace = node.getNamespace();
                if (namespace == null) {
                    return false;
                }
                NamespaceDefinition ndef = this.namespaces.getDefinition(namespace);
                if (ndef == null) {
                    return false;
                }
                String[] classAttribute = ndef.getClassAttribute(node.getTagName());
                for (int i = 0; i < classAttribute.length; ++i) {
                    String attr = classAttribute[i];
                    String htmlAttr = (String)node.getAttribute(namespace, attr);
                    if (!this.isOneOfAttributes(htmlAttr, ac.getValue())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                AttributeCondition ac = (AttributeCondition)condition;
                Object id = node.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
                return ObjectUtilities.equal((Object)ac.getValue(), (Object)id);
            }
            case 6: {
                AttributeCondition ac = (AttributeCondition)condition;
                Locale locale = node.getLanguage();
                String lang = locale.getLanguage();
                return this.isBeginHyphenAttribute(lang, ac.getValue());
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !this.evaluateCondition(node, nc.getCondition());
            }
            case 7: {
                AttributeCondition ac = (AttributeCondition)condition;
                String attr = (String)node.getAttribute(ac.getNamespaceURI(), ac.getLocalName());
                return this.isOneOfAttributes(attr, ac.getValue());
            }
            case 10: {
                AttributeCondition ac = (AttributeCondition)condition;
                String pseudoClass = node.getPseudoElement();
                if (pseudoClass == null) {
                    return false;
                }
                return pseudoClass.equals(ac.getValue());
            }
        }
        return false;
    }

    private boolean isOneOfAttributes(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (attrValue.equals(value)) {
            return true;
        }
        StringTokenizer strTok = new StringTokenizer(attrValue);
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeginHyphenAttribute(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        return attrValue.startsWith(value);
    }

    private boolean isDescendantMatch(LayoutElement node, Selector selector) {
        for (LayoutElement parent = node.getParentLayoutElement(); parent != null; parent = parent.getParentLayoutElement()) {
            if (!this.isMatch(parent, selector)) continue;
            return true;
        }
        return false;
    }

    private boolean isSilblingMatch(LayoutElement node, SiblingSelector select) {
        for (LayoutElement pred = node.getPreviousLayoutElement(); pred != null; pred = pred.getPreviousLayoutElement()) {
            if (!this.isMatch(pred, (Selector)select)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CSSPageRule[] getPageRule(CSSValue pageName, PseudoPage[] pseudoPages) {
        CSSPageRule[] pageRules = this.pageRules;
        ArrayList<CSSPageRule> rules = new ArrayList<CSSPageRule>();
        for (int i = 0; i < pageRules.length; ++i) {
            CSSPageRule rule = pageRules[i];
            String rulePageName = rule.getName();
            if (rulePageName != null && !rulePageName.equals(pageName)) continue;
            String rulePseudoPage = rule.getPseudoPage();
            if (rulePseudoPage != null) {
                for (int j = 0; j < pseudoPages.length; ++j) {
                    PseudoPage pseudoPage = pseudoPages[j];
                    if (!pseudoPage.toString().equalsIgnoreCase(rulePseudoPage)) continue;
                    rules.add(rule);
                }
                continue;
            }
            rules.add(rule);
        }
        return rules.toArray(new CSSPageRule[rules.size()]);
    }
}

