/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.autovalue.fonts;

import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.dom.OutputProcessorFeature;
import org.pentaho.reporting.libraries.css.keys.font.FontSmooth;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FontSmoothResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        double threshold;
        LayoutOutputMetaData metaData;
        int resolution;
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(FontStyleKeys.FONT_SIZE);
        double fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution = (int)(metaData = process.getOutputMetaData()).getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION));
        if (fontSize < (threshold = metaData.getNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD))) {
            layoutContext.setValue(FontStyleKeys.FONT_SMOOTH, FontSmooth.NEVER);
        } else {
            layoutContext.setValue(FontStyleKeys.FONT_SMOOTH, FontSmooth.ALWAYS);
        }
    }
}

