/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed;

import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;

public abstract class ListOfConstantsResolveHandler
extends ConstantsResolveHandler {
    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        CSSValue value = currentNode.getLayoutStyle().getValue(key);
        if (value == null) {
            return;
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        CSSValueList list = (CSSValueList)value;
        int length = list.getLength();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            CSSValue item = list.getItem(i);
            if (!(item instanceof CSSConstant)) {
                this.resolveInvalidItem(process, currentNode, key, i);
                continue;
            }
            this.resolveItem(process, currentNode, key, i, (CSSConstant)item);
        }
    }

    protected void resolveInvalidItem(DocumentContext process, LayoutElement currentNode, StyleKey key, int index) {
        DebugLog.log((Object)("Encountered invalid item in Style " + key + " at index " + index));
    }

    protected abstract boolean resolveItem(DocumentContext var1, LayoutElement var2, StyleKey var3, int var4, CSSConstant var5);
}

