/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.selectors;

import java.io.Serializable;

public final class SelectorWeight
implements Comparable,
Serializable {
    private int styleAttribute;
    private int idCount;
    private int attributeCount;
    private int elementCount;

    public SelectorWeight(int styleAttribute, int idCount, int attributeCount, int elementCount) {
        this(null, styleAttribute, idCount, attributeCount, elementCount);
    }

    public SelectorWeight(SelectorWeight first, SelectorWeight second) {
        this.styleAttribute = first.styleAttribute + second.styleAttribute;
        this.idCount = first.idCount + second.idCount;
        this.attributeCount = first.attributeCount + second.attributeCount;
        this.elementCount = first.elementCount + second.attributeCount;
    }

    public SelectorWeight(SelectorWeight parent, int styleAttribute, int idCount, int attributeCount, int elementCount) {
        if (parent == null) {
            this.styleAttribute = styleAttribute;
            this.idCount = idCount;
            this.attributeCount = attributeCount;
            this.elementCount = elementCount;
        } else {
            this.styleAttribute = styleAttribute + parent.styleAttribute;
            this.idCount = idCount + parent.idCount;
            this.attributeCount = attributeCount + parent.attributeCount;
            this.elementCount = elementCount + parent.elementCount;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorWeight that = (SelectorWeight)o;
        if (this.attributeCount != that.attributeCount) {
            return false;
        }
        if (this.elementCount != that.elementCount) {
            return false;
        }
        if (this.idCount != that.idCount) {
            return false;
        }
        return this.styleAttribute == that.styleAttribute;
    }

    public int hashCode() {
        int result = this.styleAttribute;
        result = 29 * result + this.idCount;
        result = 29 * result + this.attributeCount;
        result = 29 * result + this.elementCount;
        return result;
    }

    public int compareTo(Object o) {
        SelectorWeight weight = (SelectorWeight)o;
        if (this.styleAttribute < weight.styleAttribute) {
            return -1;
        }
        if (this.styleAttribute > weight.styleAttribute) {
            return 1;
        }
        if (this.idCount < weight.idCount) {
            return -1;
        }
        if (this.idCount > weight.idCount) {
            return 1;
        }
        if (this.attributeCount < weight.attributeCount) {
            return -1;
        }
        if (this.attributeCount > weight.attributeCount) {
            return 1;
        }
        if (this.elementCount < weight.elementCount) {
            return -1;
        }
        if (this.elementCount > weight.elementCount) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "SelectorWeight{styleAttribute=" + this.styleAttribute + ", idCount=" + this.idCount + ", attributeCount=" + this.attributeCount + ", elementCount=" + this.elementCount + '}';
    }
}

