/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cgg.SetResponseHeaderDelegate;
import pt.webdetails.cgg.WebCgg;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.MimeTypes;

@Path(value="/cgg/api/services")
public class CggService {
    private static final String CCC_VERSION_PARAM = "cccVersion";
    private static final String CCC_MULTICHART_OVERFLOW_PARAM = "multiChartOverflow";
    private static final String CCC_MULTICHART_OVERFLOW_PAGE = "page";
    private static final String CONTEXT_PATH_PARAM = "CONTEXT_PATH";
    private static final Log logger = LogFactory.getLog(CggService.class);
    private OutputStream outputStream;

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    @GET
    @Path(value="/refresh")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/xml", "application/json"})
    public Response refresh() {
        WebCgg cgg = new WebCgg(null, null, null, null);
        cgg.refresh();
        return Response.ok().build();
    }

    @GET
    @Path(value="/draw")
    @Consumes(value={"application/xml", "application/json"})
    public void draw(@QueryParam(value="script") String script, @DefaultValue(value="svg") @QueryParam(value="type") String type, @DefaultValue(value="png") @QueryParam(value="outputType") String outputType, @DefaultValue(value="") @QueryParam(value="attachmentName") String attachmentName, @DefaultValue(value="grow") @QueryParam(value="multiChartOverflow") String multiChartOverflow, @DefaultValue(value="0") @QueryParam(value="width") Long width, @DefaultValue(value="0") @QueryParam(value="height") Long height, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) {
        this.draw(script, type, outputType, attachmentName, multiChartOverflow, null, width, height, servletResponse, servletRequest, null);
    }

    public void draw(String script, String type, String outputType, String attachmentName, Long width, Long height, HttpServletResponse servletResponse, HttpServletRequest servletRequest) {
        this.draw(script, type, outputType, attachmentName, null, null, width, height, servletResponse, servletRequest, null);
    }

    public void draw(String script, String type, final String outputType, final String attachmentName, String multiChartOverflow, String cccLibVersion, Long width, Long height, final HttpServletResponse servletResponse, HttpServletRequest servletRequest, IPentahoSession userSession) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (servletRequest != null) {
                Enumeration inputParams = servletRequest.getParameterNames();
                while (inputParams.hasMoreElements()) {
                    String paramName = (String)inputParams.nextElement();
                    if (!paramName.startsWith("param")) continue;
                    String pName = paramName.substring(5);
                    String[] p = servletRequest.getParameterValues(paramName);
                    if (p.length == 1) {
                        params.put(pName, p[0]);
                        continue;
                    }
                    params.put(pName, p);
                }
            }
            if (!StringUtils.isEmpty((String)multiChartOverflow)) {
                multiChartOverflow = multiChartOverflow.toLowerCase();
                params.put(CCC_MULTICHART_OVERFLOW_PARAM, multiChartOverflow);
            }
            final boolean isMultiPage = CCC_MULTICHART_OVERFLOW_PAGE.equals(multiChartOverflow);
            if (!StringUtils.isEmpty((String)cccLibVersion)) {
                params.put(CCC_VERSION_PARAM, cccLibVersion);
            }
            String serverURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            params.put(CONTEXT_PATH_PARAM, new URL(serverURL).getPath());
            if (!script.startsWith("/")) {
                script = "/" + script;
            }
            String replacedScript = StringUtils.replace((String)script, (String)"\\", (String)"/");
            File f = new File(replacedScript);
            URL context = new URL("file", "", StringUtils.replace((String)replacedScript, (String)f.getName(), (String)""));
            if (servletResponse != null) {
                servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
            }
            if (userSession == null) {
                userSession = PentahoSessionHolder.getSession();
            }
            WebCgg cgg = new WebCgg(context, servletResponse, userSession, servletResponse == null ? this.outputStream : servletResponse.getOutputStream(), new SetResponseHeaderDelegate(){

                @Override
                public void setResponseHeader(String mimeType) {
                    if (!attachmentName.isEmpty()) {
                        String fileName = attachmentName.indexOf(".") > 0 ? attachmentName : attachmentName + "." + outputType;
                        CggService.this.setResponseHeaders(MimeTypes.getMimeType((String)fileName), fileName, servletResponse);
                    } else if (isMultiPage) {
                        CggService.this.setResponseHeaders("multipart/mixed", servletResponse);
                    } else {
                        CggService.this.setResponseHeaders(mimeType, servletResponse);
                    }
                }
            });
            cgg.draw(replacedScript, type, outputType, width.intValue(), height.intValue(), isMultiPage, params);
        }
        catch (Exception ex) {
            logger.fatal((Object)"Error while rendering script", (Throwable)ex);
        }
    }

    protected void setResponseHeaders(String mimeType, HttpServletResponse response) {
        this.setResponseHeaders(mimeType, 0, null, response);
    }

    protected void setResponseHeaders(String mimeType, String attachmentName, HttpServletResponse response) {
        this.setResponseHeaders(mimeType, 0, attachmentName, response);
    }

    protected void setResponseHeaders(String mimeType, int cacheDuration, String attachmentName, HttpServletResponse response) {
        if (response == null) {
            logger.warn((Object)"Parameter 'httpresponse' not found!");
            return;
        }
        response.setHeader("Content-Type", mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        if (cacheDuration > 0) {
            response.setHeader("Cache-Control", "max-age=" + cacheDuration);
        } else {
            response.setHeader("Cache-Control", "max-age=0, no-store");
        }
    }
}

