/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;
import pt.webdetails.cpf.repository.pentaho.SystemPluginResourceAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class SystemFolderScriptResourceLoader
implements ScriptResourceLoader {
    private String basePath;

    public SystemFolderScriptResourceLoader(String basePath) {
        this.basePath = basePath;
    }

    public Reader getSystemLibraryScript(String s) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(s);
    }

    public Reader getContextLibraryScript(String s) throws IOException, ScriptResourceNotFoundException {
        return new InputStreamReader(this.getContextResource(s), CharsetHelper.getEncoding());
    }

    public String getContextResourceURI(String s) throws IOException, ScriptResourceNotFoundException {
        return "file://" + s;
    }

    public InputStream getContextResource(String s) throws IOException, ScriptResourceNotFoundException {
        String plugin;
        String fullPath = s;
        Boolean isSystem = s.startsWith("/system");
        Boolean isPlugin = s.startsWith("/plugin");
        if (!isSystem.booleanValue() && !isPlugin.booleanValue()) {
            if (this.basePath == null || !this.basePath.startsWith("/system")) {
                throw new ScriptResourceNotFoundException(s);
            }
            fullPath = this.basePath + "/" + s;
            isSystem = true;
        }
        if (isSystem.booleanValue()) {
            plugin = "cgg";
        } else {
            Object[] sections = fullPath.split("/");
            plugin = sections[2];
            sections = (String[])ArrayUtils.remove((Object[])sections, (int)1);
            sections = (String[])ArrayUtils.remove((Object[])sections, (int)1);
            fullPath = StringUtils.join((Object[])sections, (String)"/");
        }
        SystemPluginResourceAccess resourceAccess = new SystemPluginResourceAccess(plugin, "");
        return resourceAccess.getFileInputStream(fullPath);
    }

    public InputStream getWebResource(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }
}

