/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdMemory;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;

public class HiveRelMdMemory
extends RelMdMemory {
    private static final HiveRelMdMemory INSTANCE = new HiveRelMdMemory();
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Object)((Object)INSTANCE), (Method[])new Method[]{BuiltInMethod.MEMORY.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE_SPLIT.method});

    private HiveRelMdMemory() {
    }

    public Double memory(HiveTableScan tableScan, RelMetadataQuery mq) {
        return 0.0;
    }

    public Double memory(HiveAggregate aggregate, RelMetadataQuery mq) {
        Double avgRowSize = mq.getAverageRowSize(aggregate.getInput());
        Double rowCount = mq.getRowCount(aggregate.getInput());
        if (avgRowSize == null || rowCount == null) {
            return null;
        }
        return avgRowSize * rowCount;
    }

    public Double memory(HiveFilter filter, RelMetadataQuery mq) {
        return 0.0;
    }

    public Double memory(HiveJoin join, RelMetadataQuery mq) {
        return join.getMemory();
    }

    public Double cumulativeMemoryWithinPhaseSplit(HiveJoin join) {
        return join.getCumulativeMemoryWithinPhaseSplit();
    }

    public Double memory(HiveProject project, RelMetadataQuery mq) {
        return 0.0;
    }

    public Double memory(HiveSortLimit sort, RelMetadataQuery mq) {
        if (sort.getCollation() != RelCollations.EMPTY) {
            Double avgRowSize = mq.getAverageRowSize(sort.getInput());
            Double rowCount = mq.getRowCount(sort.getInput());
            if (avgRowSize == null || rowCount == null) {
                return null;
            }
            return avgRowSize * rowCount;
        }
        return 0.0;
    }

    public Double memory(HiveUnion union, RelMetadataQuery mq) {
        return 0.0;
    }
}

