/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.drilldown;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.auth.AuthenticationStore;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.DefaultXulDrillDownController;
import org.pentaho.reporting.designer.core.editor.drilldown.basic.XulDrillDownParameterTable;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoParameterRefreshHandler;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.PentahoPathModel;
import org.pentaho.reporting.designer.extensions.pentaho.drilldown.SelectDrillTargetTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.LoginTask;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.dom.Document;

public abstract class PentahoDrillDownController
extends DefaultXulDrillDownController {
    private PentahoPathModel pentahoPathWrapper;
    private PentahoParameterRefreshHandler parameterRefreshHandler;
    private ReportDesignerContext reportDesignerContext;

    protected PentahoDrillDownController() {
    }

    protected PentahoPathModel getPentahoPathWrapper() {
        return this.pentahoPathWrapper;
    }

    protected abstract String getProfileName();

    public void init(ReportDesignerContext reportDesignerContext, DrillDownModel model, String[] fields) {
        DrillDownParameterTable drillDownParameterTable;
        XulComponent serverElement;
        XulComponent hideParameterUiElement;
        XulComponent localServerElement;
        this.reportDesignerContext = reportDesignerContext;
        super.init(reportDesignerContext, model, fields);
        DrillDownParameter[] drillDownParameter = model.getDrillDownParameter();
        this.pentahoPathWrapper = new PentahoPathModel(reportDesignerContext);
        this.pentahoPathWrapper.addPropertyChangeListener(new PentahoWrapperUpdateHandler());
        DrillDownProfile[] drillDownProfileByGroup = DrillDownProfileMetaData.getInstance().getDrillDownProfileByGroup(this.getProfileName());
        for (int i = 0; i < drillDownProfileByGroup.length; ++i) {
            DrillDownProfile profile = drillDownProfileByGroup[i];
            String profileName = profile.getName();
            String extension = profile.getAttribute("extension");
            boolean noParameter = profileName.endsWith("-no-parameter");
            boolean local = profileName.startsWith("local-");
            if (StringUtils.isEmpty((String)extension)) {
                this.pentahoPathWrapper.registerExtension(null, local, noParameter, profileName);
                continue;
            }
            this.pentahoPathWrapper.registerExtension("." + extension, local, noParameter, profileName);
        }
        Object context = this.getXulDomContainer().getOuterContext();
        Component c = context instanceof Component ? (Component)context : this.getReportDesignerContext().getView().getParent();
        this.parameterRefreshHandler = new PentahoParameterRefreshHandler(this.pentahoPathWrapper, reportDesignerContext, c);
        Document doc = this.getXulDomContainer().getDocumentRoot();
        DefaultBindingFactory bindingFactory = new DefaultBindingFactory();
        bindingFactory.setDocument(doc);
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        XulComponent configElement = doc.getElementById("local-path");
        if (configElement != null) {
            bindingFactory.createBinding((Object)this.pentahoPathWrapper, "localPath", "local-path", "value", new BindingConvertor[0]);
        }
        if ((localServerElement = doc.getElementById("local-server-used")) != null) {
            bindingFactory.createBinding((Object)this.pentahoPathWrapper, "useRemoteServer", "local-server-used", "checked", new BindingConvertor[0]);
        }
        if ((hideParameterUiElement = doc.getElementById("parameter-table")) != null) {
            bindingFactory.createBinding((Object)this.pentahoPathWrapper, "hideParameterUi", "parameter-table", "hideParameterUi", new BindingConvertor[0]);
        }
        if ((serverElement = doc.getElementById("server-login")) != null) {
            bindingFactory.createBinding((Object)this.pentahoPathWrapper, "serverPath", "server-login", "value", new BindingConvertor[0]);
        }
        if ((drillDownParameterTable = this.getTable()) != null) {
            drillDownParameterTable.setFilteredParameterNames(new String[]{"solution", "path", "name"});
            drillDownParameterTable.addDrillDownParameterRefreshListener((DrillDownParameterRefreshListener)this.parameterRefreshHandler);
            this.parameterRefreshHandler.setParameterTable(drillDownParameterTable);
        }
        model.setDrillDownParameter(drillDownParameter);
        this.pentahoPathWrapper.setLocalPathFromParameter(model.getDrillDownParameter());
        if (StringUtils.isEmpty((String)model.getDrillDownPath())) {
            this.pentahoPathWrapper.setUseRemoteServer(false);
            ReportDocumentContext reportRenderContext = reportDesignerContext.getActiveContext();
            if (reportRenderContext != null) {
                Object o = reportRenderContext.getProperties().get("pentaho-login-url");
                if (o != null) {
                    this.pentahoPathWrapper.setServerPath(String.valueOf(o));
                } else {
                    this.pentahoPathWrapper.setServerPath(null);
                }
            } else {
                this.pentahoPathWrapper.setServerPath(null);
            }
        } else {
            this.pentahoPathWrapper.setUseRemoteServer(true);
            this.pentahoPathWrapper.setServerPath(model.getDrillDownPath());
        }
        this.configureDisableTableOnEmptyFile();
    }

    protected void configureDisableTableOnEmptyFile() {
        Document doc = this.getXulDomContainer().getDocumentRoot();
        XulComponent paramTableElement = doc.getElementById("parameter-table");
        if (!(paramTableElement instanceof XulDrillDownParameterTable)) {
            return;
        }
        this.pentahoPathWrapper.addPropertyChangeListener("localPath", new CheckEmptyPathHandler(paramTableElement));
    }

    public void login() {
        Object context = this.getXulDomContainer().getOuterContext();
        Component c = context instanceof Component ? (Component)context : this.getReportDesignerContext().getView().getParent();
        LoginTask loginTask = new LoginTask(this.getReportDesignerContext(), c, new LoginCompleteTask(null));
        SwingUtilities.invokeLater(loginTask);
    }

    public void browse() {
        Object context;
        String path;
        ReportDocumentContext activeContext = this.getReportDesignerContext().getActiveContext();
        if (this.pentahoPathWrapper.getLoginData() == null && (path = this.getModel().getDrillDownPath()) != null) {
            AuthenticationStore authStore = activeContext.getAuthenticationStore();
            String username = authStore.getUsername(path);
            String password = authStore.getPassword(path);
            int timeout = authStore.getIntOption(path, "timeout", 0);
            this.pentahoPathWrapper.setLoginData(new AuthenticationData(path, username, password, timeout));
        }
        Component c = (context = this.getXulDomContainer().getOuterContext()) instanceof Component ? (Component)context : this.getReportDesignerContext().getView().getParent();
        LoginTask loginTask = new LoginTask(this.getReportDesignerContext(), c, new LoginCompleteTask(new SelectDrillTargetTask(this.pentahoPathWrapper, c, (Runnable)new DefaultXulDrillDownController.RefreshParameterTask((DefaultXulDrillDownController)this), activeContext)), this.pentahoPathWrapper.getLoginData());
        SwingUtilities.invokeLater(loginTask);
    }

    public void deactivate() {
    }

    private class CheckEmptyPathHandler
    implements PropertyChangeListener {
        private XulComponent paramTableElement;

        private CheckEmptyPathHandler(XulComponent paramTableElement) {
            this.paramTableElement = paramTableElement;
            this.propertyChange(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtils.isEmpty((String)PentahoDrillDownController.this.pentahoPathWrapper.getLocalPath())) {
                this.paramTableElement.setDisabled(true);
            } else {
                this.paramTableElement.setDisabled(false);
            }
        }
    }

    private class PentahoWrapperUpdateHandler
    implements PropertyChangeListener {
        private PentahoWrapperUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("localPath".equals(evt.getPropertyName())) {
                PentahoDrillDownController.this.getWrapper().setDrillDownParameter(PentahoDrillDownController.this.filterParameter(PentahoDrillDownController.this.getWrapper().getDrillDownParameter()));
                PentahoDrillDownController.this.getWrapper().setDrillDownConfig(PentahoDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
            } else if ("useRemoteServer".equals(evt.getPropertyName())) {
                PentahoDrillDownController.this.getWrapper().setDrillDownConfig(PentahoDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
                if (!PentahoDrillDownController.this.pentahoPathWrapper.isUseRemoteServer()) {
                    PentahoDrillDownController.this.getWrapper().setDrillDownPath(null);
                } else {
                    PentahoDrillDownController.this.getWrapper().setDrillDownPath(PentahoDrillDownController.this.pentahoPathWrapper.getServerPath());
                }
            } else if ("hideParameterUi".equals(evt.getPropertyName())) {
                PentahoDrillDownController.this.getWrapper().setDrillDownConfig(PentahoDrillDownController.this.pentahoPathWrapper.getDrillDownProfile());
            } else if ("loginData".equals(evt.getPropertyName())) {
                if (!PentahoDrillDownController.this.pentahoPathWrapper.isUseRemoteServer()) {
                    PentahoDrillDownController.this.getWrapper().setDrillDownPath(null);
                } else {
                    PentahoDrillDownController.this.getWrapper().setDrillDownPath(PentahoDrillDownController.this.pentahoPathWrapper.getServerPath());
                }
            }
        }
    }

    private class LoginCompleteTask
    implements AuthenticatedServerTask {
        private AuthenticationData loginData;
        private boolean storeUpdates;
        private AuthenticatedServerTask nextTask;

        private LoginCompleteTask(AuthenticatedServerTask nextTask) {
            this.nextTask = nextTask;
        }

        @Override
        public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
            this.loginData = loginData;
            this.storeUpdates = storeUpdates;
        }

        @Override
        public void run() {
            PentahoDrillDownController.this.pentahoPathWrapper.setLoginData(this.loginData);
            ReportDocumentContext reportRenderContext = PentahoDrillDownController.this.reportDesignerContext.getActiveContext();
            Object o = reportRenderContext.getProperties().get("pentaho-login-url");
            if (o == null) {
                reportRenderContext.getProperties().put("pentaho-login-url", this.loginData.getUrl());
            }
            if (this.nextTask != null) {
                this.nextTask.setLoginData(this.loginData, this.storeUpdates);
                SwingUtilities.invokeLater(this.nextTask);
            }
        }
    }
}

