/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository;

import java.util.HashSet;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.ParameterLocationInfo;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class ReservedParameterNamesInspection
implements Inspection {
    private HashSet<String> reservedParameterNames = new HashSet();

    public ReservedParameterNamesInspection() {
        this.reservedParameterNames.add("solution");
        this.reservedParameterNames.add("name");
        this.reservedParameterNames.add("path");
        this.reservedParameterNames.add("action");
        this.reservedParameterNames.add("renderMode");
        this.reservedParameterNames.add("paginate");
        this.reservedParameterNames.add("autoSubmit");
        this.reservedParameterNames.add("subscribe");
        this.reservedParameterNames.add("subscription-id");
        this.reservedParameterNames.add("subscription-name");
        this.reservedParameterNames.add("destination");
        this.reservedParameterNames.add("output-type");
        this.reservedParameterNames.add("output-target");
        this.reservedParameterNames.add("report-definition");
        this.reservedParameterNames.add("useContentRepository");
        this.reservedParameterNames.add("accepted-page");
        this.reservedParameterNames.add("print");
        this.reservedParameterNames.add("printer-name");
        this.reservedParameterNames.add("content-handler-pattern");
        this.reservedParameterNames.add("workbook");
        this.reservedParameterNames.add("res-url");
    }

    public boolean isInlineInspection() {
        return true;
    }

    public void inspect(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler) throws ReportDataFactoryException {
        AbstractReportDefinition abstractReportDefinition = reportRenderContext.getReportDefinition();
        if (!(abstractReportDefinition instanceof MasterReport)) {
            return;
        }
        MasterReport report = (MasterReport)abstractReportDefinition;
        ReportParameterDefinition definition = report.getParameterDefinition();
        ParameterDefinitionEntry[] parameterDefinitionEntries = definition.getParameterDefinitions();
        for (int i = 0; i < parameterDefinitionEntries.length; ++i) {
            ParameterDefinitionEntry definitionEntry = parameterDefinitionEntries[i];
            if (!this.reservedParameterNames.contains(definitionEntry.getName())) continue;
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getInstance().formatMessage("ReservedParameterNamesInspection.ReservedParameterNameUsed", definitionEntry.getName()), (LocationInfo)new ParameterLocationInfo(definitionEntry)));
        }
    }
}

