/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.util;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.pentaho.reporting.designer.extensions.pentaho.repository.model.RepositoryTableModel;

public class RepositoryEntryCellRenderer
extends DefaultTableCellRenderer {
    private Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private Icon closedIcon = UIManager.getIcon("Tree.closedIcon");

    public RepositoryEntryCellRenderer() {
        this.putClientProperty("html.disable", Boolean.TRUE);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            if (column == 0) {
                RepositoryTableModel tableModel = (RepositoryTableModel)table.getModel();
                RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
                FileObject e = rowSorter != null ? tableModel.getElementForRow(rowSorter.convertRowIndexToModel(row)) : tableModel.getElementForRow(row);
                if (e.getType() == FileType.FOLDER) {
                    component.setIcon(this.closedIcon);
                } else {
                    component.setIcon(this.leafIcon);
                }
            } else {
                component.setIcon(null);
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return component;
    }
}

