/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class RepositoryPathEncoder {
    public static String encode(String value) {
        String encoded = RepositoryPathEncoder.encodeURIComponent(value);
        return encoded.replace("%5C", "%255C").replace("%2F", "%252F");
    }

    public static String encodeURIComponent(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            encoded = value;
        }
        return encoded;
    }

    public static String encodeRepositoryPath(String path) {
        return path.replace(":", "\t").replace("/", ":");
    }

    public static String decodeRepositoryPath(String path) {
        return path.replace(":", "/").replace("\t", ":");
    }
}

