/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types;

import org.pentaho.metadata.model.concept.types.ColumnWidth;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.types.ColumnWidthWrapper;

public class ColumnWidthConceptMapper
implements ConceptQueryMapper {
    public static final ConceptQueryMapper INSTANCE = new ColumnWidthConceptMapper();

    public Object getValue(Object value, Class type, DataAttributeContext context) {
        float rawWidth;
        if (value == null) {
            return null;
        }
        if (!(value instanceof ColumnWidth)) {
            return null;
        }
        if (type == null || Object.class.equals((Object)type) || ColumnWidth.class.equals((Object)type)) {
            if (value instanceof ColumnWidthWrapper) {
                return value;
            }
            return new ColumnWidthWrapper((ColumnWidth)value);
        }
        ColumnWidth width = (ColumnWidth)value;
        float widthValue = (float)width.getWidth();
        ColumnWidth.WidthType widthType = width.getType();
        if (widthType == ColumnWidth.WidthType.CM) {
            rawWidth = widthValue * 28.346457f;
        } else if (widthType == ColumnWidth.WidthType.INCHES) {
            rawWidth = 72.0f * widthValue;
        } else if (widthType == ColumnWidth.WidthType.PERCENT) {
            rawWidth = -Math.max(0.0f, widthValue);
        } else if (widthType == ColumnWidth.WidthType.PIXELS) {
            OutputProcessorMetaData data = context.getOutputProcessorMetaData();
            double resolution = data.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            double deviceScaleFactor = 72.0 / resolution;
            rawWidth = (float)((double)widthValue * deviceScaleFactor);
        } else {
            rawWidth = Math.max(0.0f, widthValue);
        }
        String valueAsString = String.valueOf(rawWidth);
        if (String.class.isAssignableFrom(type)) {
            return valueAsString;
        }
        try {
            return ConverterRegistry.toPropertyValue((String)valueAsString, (Class)type);
        }
        catch (BeanException beanException) {
            return null;
        }
    }
}

