/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType {
    BOOLEAN(1, 16, 0),
    BYTE(2, -6, 1),
    INT(3, 5, 2),
    LONG(4, 4, 4),
    MONEY(5, 3, 8),
    FLOAT(6, 6, 4),
    DOUBLE(7, 8, 8),
    SHORT_DATE_TIME(8, 93, 8),
    BINARY(9, -2, null, true, false, 0, 255, 255, 1),
    TEXT(10, 12, null, true, false, 0, 100, 510, 2),
    OLE(11, -4, null, true, true, 0, null, 0x3FFFFFFF, 1),
    MEMO(12, -1, null, true, true, 0, null, 0x3FFFFFFF, 2),
    UNKNOWN_0D(13, null, null, true, false, 0, 255, 255, 1),
    GUID(15, null, 16),
    NUMERIC(16, 2, 17, true, false, 17, 17, 17, true, 0, 0, 28, 1, 18, 28, 1),
    UNKNOWN_11(17, null, 3992),
    COMPLEX_TYPE(18, null, 4),
    UNSUPPORTED_FIXEDLEN(-2, null, null),
    UNSUPPORTED_VARLEN(-1, null, null, true, false, 0, null, 0x3FFFFFFF, 1);

    private static Map<Integer, DataType> SQL_TYPES;
    private static Map<Integer, DataType> ALT_SQL_TYPES;
    private static Map<Byte, DataType> DATA_TYPES;
    private boolean _variableLength;
    private boolean _longValue;
    private boolean _hasScalePrecision;
    private byte _value;
    private Integer _fixedSize;
    private Integer _minSize;
    private Integer _defaultSize;
    private Integer _maxSize;
    private Integer _sqlType;
    private Integer _minScale;
    private Integer _defaultScale;
    private Integer _maxScale;
    private Integer _minPrecision;
    private Integer _defaultPrecision;
    private Integer _maxPrecision;
    private int _unitSize;

    private DataType(byte value) {
        this(value, null, null);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize) {
        this(value, sqlType, fixedSize, false, false, null, null, null, 1);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, Integer minSize, Integer defaultSize, Integer maxSize, int unitSize) {
        this(value, sqlType, fixedSize, variableLength, longValue, minSize, defaultSize, maxSize, false, null, null, null, null, null, null, unitSize);
    }

    private DataType(byte value, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, Integer minSize, Integer defaultSize, Integer maxSize, boolean hasScalePrecision, Integer minScale, Integer defaultScale, Integer maxScale, Integer minPrecision, Integer defaultPrecision, Integer maxPrecision, int unitSize) {
        this._value = value;
        this._sqlType = sqlType;
        this._fixedSize = fixedSize;
        this._variableLength = variableLength;
        this._longValue = longValue;
        this._minSize = minSize;
        this._defaultSize = defaultSize;
        this._maxSize = maxSize;
        this._hasScalePrecision = hasScalePrecision;
        this._minScale = minScale;
        this._defaultScale = defaultScale;
        this._maxScale = maxScale;
        this._minPrecision = minPrecision;
        this._defaultPrecision = defaultPrecision;
        this._maxPrecision = maxPrecision;
        this._unitSize = unitSize;
    }

    public byte getValue() {
        return this._value;
    }

    public boolean isVariableLength() {
        return this._variableLength;
    }

    public boolean isTrueVariableLength() {
        return this.isVariableLength() && this.getMinSize() != this.getMaxSize();
    }

    public boolean isLongValue() {
        return this._longValue;
    }

    public boolean getHasScalePrecision() {
        return this._hasScalePrecision;
    }

    public int getFixedSize() {
        return this.getFixedSize(null);
    }

    public int getFixedSize(Short colLength) {
        if (this._fixedSize != null) {
            if (colLength != null) {
                return Math.max(this._fixedSize, colLength.shortValue());
            }
            return this._fixedSize;
        }
        if (colLength != null) {
            return colLength.shortValue();
        }
        throw new IllegalArgumentException("Unexpected fixed length column " + (Object)((Object)this));
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getDefaultSize() {
        return this._defaultSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSQLType() throws SQLException {
        if (this._sqlType != null) {
            return this._sqlType;
        }
        throw new SQLException("Unsupported data type: " + this.toString());
    }

    public int getMinScale() {
        return this._minScale;
    }

    public int getDefaultScale() {
        return this._defaultScale;
    }

    public int getMaxScale() {
        return this._maxScale;
    }

    public int getMinPrecision() {
        return this._minPrecision;
    }

    public int getDefaultPrecision() {
        return this._defaultPrecision;
    }

    public int getMaxPrecision() {
        return this._maxPrecision;
    }

    public int getUnitSize() {
        return this._unitSize;
    }

    public int toUnitSize(int size) {
        return size / this.getUnitSize();
    }

    public int fromUnitSize(int unitSize) {
        return unitSize * this.getUnitSize();
    }

    public boolean isValidSize(int size) {
        return DataType.isWithinRange(size, this.getMinSize(), this.getMaxSize());
    }

    public boolean isValidScale(int scale) {
        return DataType.isWithinRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public boolean isValidPrecision(int precision) {
        return DataType.isWithinRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    private static boolean isWithinRange(int value, int minValue, int maxValue) {
        return value >= minValue && value <= maxValue;
    }

    public int toValidSize(int size) {
        return DataType.toValidRange(size, this.getMinSize(), this.getMaxSize());
    }

    public int toValidScale(int scale) {
        return DataType.toValidRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public int toValidPrecision(int precision) {
        return DataType.toValidRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    public boolean isTextual() {
        return this == TEXT || this == MEMO;
    }

    public boolean mayBeAutoNumber() {
        return this == LONG || this == GUID || this == COMPLEX_TYPE;
    }

    public boolean isMultipleAutoNumberAllowed() {
        return this == COMPLEX_TYPE;
    }

    public boolean isUnsupported() {
        return this == UNSUPPORTED_FIXEDLEN || this == UNSUPPORTED_VARLEN;
    }

    private static int toValidRange(int value, int minValue, int maxValue) {
        return value > maxValue ? maxValue : (value < minValue ? minValue : value);
    }

    public static DataType fromByte(byte b) throws IOException {
        DataType rtn = DATA_TYPES.get(b);
        if (rtn != null) {
            return rtn;
        }
        throw new IOException("Unrecognized data type: " + b);
    }

    public static DataType fromSQLType(int sqlType) throws SQLException {
        return DataType.fromSQLType(sqlType, 0);
    }

    public static DataType fromSQLType(int sqlType, int lengthInUnits) throws SQLException {
        DataType altRtn;
        DataType rtn = SQL_TYPES.get(sqlType);
        if (rtn == null) {
            throw new SQLException("Unsupported SQL type: " + sqlType);
        }
        int size = lengthInUnits * rtn.getUnitSize();
        if (rtn.isVariableLength() && !rtn.isValidSize(size) && (altRtn = ALT_SQL_TYPES.get(sqlType)) != null && (altRtn.isLongValue() || altRtn.isValidSize(size))) {
            rtn = altRtn;
        }
        return rtn;
    }

    static {
        SQL_TYPES = new HashMap<Integer, DataType>();
        ALT_SQL_TYPES = new HashMap<Integer, DataType>();
        for (DataType type : DataType.values()) {
            if (type._sqlType == null) continue;
            SQL_TYPES.put(type._sqlType, type);
        }
        SQL_TYPES.put(-7, BYTE);
        SQL_TYPES.put(2004, OLE);
        SQL_TYPES.put(2005, MEMO);
        SQL_TYPES.put(-5, LONG);
        SQL_TYPES.put(1, TEXT);
        SQL_TYPES.put(91, SHORT_DATE_TIME);
        SQL_TYPES.put(7, DOUBLE);
        SQL_TYPES.put(92, SHORT_DATE_TIME);
        SQL_TYPES.put(-3, BINARY);
        ALT_SQL_TYPES.put(12, MEMO);
        ALT_SQL_TYPES.put(-3, OLE);
        ALT_SQL_TYPES.put(-2, OLE);
        DATA_TYPES = new HashMap<Byte, DataType>();
        for (DataType type : DataType.values()) {
            if (type.isUnsupported()) continue;
            DATA_TYPES.put(type._value, type);
        }
    }
}

