/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.trans.analyzer;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.big.data.kettle.plugins.hdfs.trans.HadoopFileMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.file.BaseFileMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public abstract class HadoopBaseStepAnalyzer<M extends BaseFileMeta>
extends ExternalResourceStepAnalyzer<M> {
    protected boolean normalizeFilePath() {
        return false;
    }

    protected Set<StepField> getUsedFields(M meta) {
        return null;
    }

    public String getResourceInputNodeType() {
        return "File Field";
    }

    public String getResourceOutputNodeType() {
        return "File Field";
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(HadoopBaseStepAnalyzer.this.getMetaClass());
            }
        };
    }

    public abstract Class<M> getMetaClass();

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor);
    }

    public IMetaverseNode createResourceNode(M meta, IExternalResourceInfo resource) throws MetaverseException {
        IMetaverseNode resourceNode = null;
        if (meta instanceof HadoopFileMeta) {
            resourceNode = this.createResourceNode(resource);
            HadoopFileMeta hMeta = (HadoopFileMeta)meta;
            String hostName = hMeta.getUrlHostName(resource.getName());
            if (StringUtils.isNotBlank((String)hostName)) {
                resourceNode.setProperty("hostName", (Object)hostName);
                resourceNode.setProperty("type", (Object)"File");
                String clusterName = hMeta.getClusterName(resource.getName());
                if (StringUtils.isNotBlank((String)clusterName)) {
                    resourceNode.setProperty("cluster", (Object)clusterName);
                }
            }
        }
        return resourceNode;
    }
}

