/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.IsSingleton;
import org.apache.camel.PollingConsumer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.DefaultEndpointUtilizationStatistics;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCache
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerCache.class);
    private final CamelContext camelContext;
    private final ServicePool<Endpoint, PollingConsumer> pool;
    private final Map<String, PollingConsumer> consumers;
    private final Object source;
    private EndpointUtilizationStatistics statistics;
    private boolean extendedStatistics;
    private int maxCacheSize;

    public ConsumerCache(Object source, CamelContext camelContext) {
        this(source, camelContext, CamelContextHelper.getMaximumCachePoolSize(camelContext));
    }

    public ConsumerCache(Object source, CamelContext camelContext, int cacheSize) {
        this(source, camelContext, ConsumerCache.createLRUCache(cacheSize));
    }

    public ConsumerCache(Object source, CamelContext camelContext, Map<String, PollingConsumer> cache) {
        this(source, camelContext, cache, camelContext.getPollingConsumerServicePool());
    }

    public ConsumerCache(Object source, CamelContext camelContext, Map<String, PollingConsumer> cache, ServicePool<Endpoint, PollingConsumer> pool) {
        this.camelContext = camelContext;
        this.consumers = cache;
        this.source = source;
        this.pool = pool;
        if (this.consumers instanceof LRUCache) {
            this.maxCacheSize = ((LRUCache)this.consumers).getMaxCacheSize();
        }
        this.extendedStatistics = camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    protected static LRUCache<String, PollingConsumer> createLRUCache(int cacheSize) {
        return new LRUCache<String, PollingConsumer>(cacheSize);
    }

    public PollingConsumer acquirePollingConsumer(Endpoint endpoint) {
        return this.doGetPollingConsumer(endpoint, true);
    }

    public void releasePollingConsumer(Endpoint endpoint, PollingConsumer pollingConsumer) {
        if (pollingConsumer instanceof ServicePoolAware) {
            this.pool.release(endpoint, pollingConsumer);
        } else {
            boolean singleton = false;
            if (pollingConsumer instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)pollingConsumer)).isSingleton();
            }
            String key = endpoint.getEndpointUri();
            boolean cached = this.consumers.containsKey(key);
            if (!singleton || !cached) {
                try {
                    if (!singleton) {
                        LOG.debug("Released PollingConsumer: {} is stopped as consumer is not singleton", (Object)endpoint);
                    } else {
                        LOG.debug("Released PollingConsumer: {} is stopped as consumer cache is full", (Object)endpoint);
                    }
                    ServiceHelper.stopAndShutdownService(pollingConsumer);
                }
                catch (Throwable ex) {
                    if (ex instanceof RuntimeCamelException) {
                        throw (RuntimeCamelException)ex;
                    }
                    throw new RuntimeCamelException(ex);
                }
            }
        }
    }

    public PollingConsumer getConsumer(Endpoint endpoint) {
        return this.doGetPollingConsumer(endpoint, true);
    }

    protected synchronized PollingConsumer doGetPollingConsumer(Endpoint endpoint, boolean pooled) {
        String key = endpoint.getEndpointUri();
        PollingConsumer answer = this.consumers.get(key);
        if (pooled && answer == null) {
            this.pool.acquire(endpoint);
        }
        if (answer == null) {
            try {
                answer = endpoint.createPollingConsumer();
                answer.start();
            }
            catch (Throwable e) {
                throw new FailedToCreateConsumerException(endpoint, e);
            }
            if (pooled && answer instanceof ServicePoolAware) {
                LOG.debug("Adding to producer service pool with key: {} for producer: {}", (Object)endpoint, (Object)answer);
                answer = this.pool.addAndAcquire(endpoint, answer);
            } else {
                boolean singleton = false;
                if (answer instanceof IsSingleton) {
                    singleton = ((IsSingleton)((Object)answer)).isSingleton();
                }
                if (singleton) {
                    LOG.debug("Adding to consumer cache with key: {} for consumer: {}", (Object)endpoint, (Object)answer);
                    this.consumers.put(key, answer);
                } else {
                    LOG.debug("Consumer for endpoint: {} is not singleton and thus not added to consumer cache", (Object)key);
                }
            }
        }
        if (answer != null && this.extendedStatistics) {
            this.statistics.onHit(key);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint) {
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint, long timeout) {
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive(timeout);
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receiveNoWait(Endpoint endpoint) {
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.doGetPollingConsumer(endpoint, true);
            Exchange exchange = consumer.receiveNoWait();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public int size() {
        int size = this.consumers.size();
        LOG.trace("size = {}", (Object)size);
        return size;
    }

    public int getCapacity() {
        int capacity = -1;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            capacity = cache.getMaxCacheSize();
        }
        return capacity;
    }

    public long getHits() {
        long hits = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            hits = cache.getHits();
        }
        return hits;
    }

    public long getMisses() {
        long misses = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            misses = cache.getMisses();
        }
        return misses;
    }

    public long getEvicted() {
        long evicted = -1L;
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            evicted = cache.getEvicted();
        }
        return evicted;
    }

    public void resetCacheStatistics() {
        if (this.consumers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.consumers;
            cache.resetStatistics();
        }
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public synchronized void purge() {
        this.consumers.clear();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ConsumerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize(this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.startServices(this.consumers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.statistics, this.pool);
        try {
            ServiceHelper.stopAndShutdownServices(this.consumers.values());
        }
        finally {
            for (PollingConsumer consumer : this.consumers.values()) {
                this.getCamelContext().removeService(consumer);
            }
        }
        this.consumers.clear();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }
}

