/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.command.wf.SuspendCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class CoordSuspendCommand
extends CoordinatorCommand<Void> {
    private String jobId;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordSuspendCommand(String id) {
        super("coord_suspend", "coord_suspend", 1, 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        try {
            CoordinatorJobBean coordJob = (CoordinatorJobBean)store.getEntityManager().find(CoordinatorJobBean.class, (Object)this.jobId);
            this.setLogInfo(coordJob);
            if (coordJob.getStatus() != Job.Status.SUCCEEDED && coordJob.getStatus() != Job.Status.FAILED) {
                this.incrJobCounter(1);
                coordJob.setStatus(Job.Status.SUSPENDED);
                coordJob.setSuspendedTime(new Date());
                List<CoordinatorActionBean> actionList = store.getActionsForCoordinatorJob(this.jobId, false);
                for (CoordinatorActionBean action : actionList) {
                    if (action.getStatus() != CoordinatorAction.Status.RUNNING || action.getExternalId() == null) continue;
                    this.queueCallable(new SuspendCommand(action.getExternalId()));
                }
                store.updateCoordinatorJob(coordJob);
            } else {
                this.log.info("CoordSuspendCommand not suspended - job finished or does not exist " + this.jobId);
            }
            return null;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordSuspendCommand for jobId=" + this.jobId);
        try {
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new CoordSuspendCommand(this.jobId), 30000L);
                this.log.warn("CoordSuspendCommand lock was not acquired -  failed " + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordSuspendCommand(this.jobId), 30000L);
            this.log.warn("CoordSuspendCommand lock acquiring failed  with exception " + e.getMessage() + " for job id " + this.jobId + ". Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordSuspendCommand for jobId=" + this.jobId);
        }
        return null;
    }
}

