/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.jdom.Element;
import org.jdom.Namespace;

public class SubmitCommand
extends WorkflowCommand<String> {
    public static final String CONFIG_DEFAULT = "config-default.xml";
    private Configuration conf;
    private String authToken;
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();

    public SubmitCommand(Configuration conf, String authToken) {
        super("submit", "submit", 1, 1);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    @Override
    protected String call(WorkflowStore store) throws StoreException, CommandException {
        this.incrJobCounter(1);
        WorkflowAppService wps = Services.get().get(WorkflowAppService.class);
        try {
            WorkflowInstance wfInstance;
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            WorkflowApp app = wps.parseDef(this.conf, this.authToken);
            XConfiguration protoActionConf = wps.createProtoActionConf(this.conf, this.authToken, true);
            WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
            Path configDefault = new Path(new Path(this.conf.get("oozie.wf.application.path")).getParent(), CONFIG_DEFAULT);
            String user = this.conf.get("user.name");
            String group = this.conf.get("group.name");
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, configDefault.toUri(), new Configuration());
            if (fs.exists(configDefault)) {
                try {
                    XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                    PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                    XConfiguration.injectDefaults(defaultConf, this.conf);
                }
                catch (IOException ex) {
                    throw new IOException("default configuration file, " + ex.getMessage(), ex);
                }
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            XConfiguration resolvedVarsConf = new XConfiguration();
            for (Map.Entry entry : this.conf) {
                resolvedVarsConf.set((String)entry.getKey(), this.conf.get((String)entry.getKey()));
            }
            this.conf = resolvedVarsConf;
            try {
                wfInstance = workflowLib.createInstance(app, this.conf);
            }
            catch (WorkflowException e) {
                throw new StoreException(e);
            }
            Configuration conf = wfInstance.getConf();
            WorkflowJobBean workflow = new WorkflowJobBean();
            workflow.setId(wfInstance.getId());
            workflow.setAppName(app.getName());
            workflow.setAppPath(conf.get("oozie.wf.application.path"));
            workflow.setConf(XmlUtils.prettyPrint(conf).toString());
            workflow.setProtoActionConf(protoActionConf.toXmlString());
            workflow.setCreatedTime(new Date());
            workflow.setLastModifiedTime(new Date());
            workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
            workflow.setStatus(WorkflowJob.Status.PREP);
            workflow.setRun(0);
            workflow.setUser(conf.get("user.name"));
            workflow.setGroup(conf.get("group.name"));
            workflow.setAuthToken(this.authToken);
            workflow.setWorkflowInstance(wfInstance);
            workflow.setExternalId(conf.get("oozie.wf.external.id"));
            this.setLogInfo(workflow);
            Element wfElem = XmlUtils.parseXml(app.getDefinition());
            ELEvaluator evalSla = SubmitCommand.createELEvaluatorForGroup(conf, "wf-sla-submit");
            String jobSlaXml = this.verifySlaElements(wfElem, evalSla);
            this.writeSLARegistration(jobSlaXml, workflow.getId(), workflow.getUser(), workflow.getGroup(), store);
            workflow.setSlaXml(jobSlaXml);
            store.insertWorkflow(workflow);
            return workflow.getId();
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (HadoopAccessorException ex) {
            throw new CommandException(ex);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0803, ex);
        }
    }

    private String verifySlaElements(Element eWfJob, ELEvaluator evalSla) throws CommandException {
        String jobSlaXml = "";
        Element eSla = eWfJob.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
        if (eSla != null) {
            jobSlaXml = SubmitCommand.resolveSla(eSla, evalSla);
        }
        for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
            eSla = action.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
            if (eSla == null) continue;
            SubmitCommand.resolveSla(eSla, evalSla);
        }
        return jobSlaXml;
    }

    private void writeSLARegistration(String slaXml, String id, String user, String group, Store store) throws CommandException {
        try {
            if (slaXml != null && slaXml.length() > 0) {
                Element eSla = XmlUtils.parseXml(slaXml);
                SLADbOperations.writeSlaRegistrationEvent(eSla, store, id, SLAEvent.SlaAppType.WORKFLOW_JOB, user, group);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException(ErrorCode.E1007, "workflow " + id, e);
        }
    }

    public static String resolveSla(Element eSla, ELEvaluator evalSla) throws CommandException {
        String slaXml = XmlUtils.prettyPrint(eSla).toString();
        try {
            slaXml = XmlUtils.removeComments(slaXml);
            slaXml = evalSla.evaluate(slaXml, String.class);
            XmlUtils.validateData(slaXml, SchemaService.SchemaName.SLA_ORIGINAL);
            return slaXml;
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, "Validation erro :" + e.getMessage(), e);
        }
    }

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), entry.getValue());
        }
        return eval;
    }

    static {
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name", "hadoop.job.ugi", "mapreduce.jobtracker.kerberos.principal", "dfs.namenode.kerberos.principal"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

