/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public abstract class IOUtils {
    public static void delete(File file) throws IOException {
        ParamChecker.notNull(file, "file");
        if (file.getAbsolutePath().length() < 5) {
            throw new RuntimeException(XLog.format("Path[{0}] is too short, not deleting", file.getAbsolutePath()));
        }
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    IOUtils.delete(child);
                }
            }
            if (!file.delete()) {
                throw new RuntimeException(XLog.format("Could not delete path[{0}]", file.getAbsolutePath()));
            }
        }
    }

    public static String getReaderAsString(Reader reader, int maxLen) throws IOException {
        int read;
        ParamChecker.notNull(reader, "reader");
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[2048];
        int count = 0;
        while ((read = reader.read(buffer)) > -1) {
            if (maxLen > -1 && (count += read) > maxLen) {
                throw new IllegalArgumentException(XLog.format("stream exceeds limit [{0}]", maxLen));
            }
            sb.append(buffer, 0, read);
        }
        reader.close();
        return sb.toString();
    }

    public static InputStream getResourceAsStream(String path, int maxLen) throws IOException {
        ParamChecker.notEmpty(path, "path");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException(XLog.format("resource [{0}] not found", path));
        }
        return is;
    }

    public static Reader getResourceAsReader(String path, int maxLen) throws IOException {
        return new InputStreamReader(IOUtils.getResourceAsStream(path, maxLen));
    }

    public static String getResourceAsString(String path, int maxLen) throws IOException {
        ParamChecker.notEmpty(path, "path");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException(XLog.format("resource [{0}] not found", path));
        }
        InputStreamReader reader = new InputStreamReader(is);
        return IOUtils.getReaderAsString(reader, maxLen);
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int read;
        ParamChecker.notNull(is, "is");
        ParamChecker.notNull(os, "os");
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer)) > -1) {
            os.write(buffer, 0, read);
        }
        os.close();
        is.close();
    }

    public static void copyCharStream(Reader reader, Writer writer) throws IOException {
        int read;
        ParamChecker.notNull(reader, "reader");
        ParamChecker.notNull(writer, "writer");
        char[] buffer = new char[4096];
        while ((read = reader.read(buffer)) > -1) {
            writer.write(buffer, 0, read);
        }
        writer.close();
        reader.close();
    }

    public static void zipDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        IOUtils.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList;
        for (String aDirList : dirList = dir.list()) {
            File f = new File(dir, aDirList);
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!start) {
                    ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                    zos.putNextEntry(dirEntry);
                    zos.closeEntry();
                }
                String filePath = f.getPath();
                File file = new File(filePath);
                IOUtils.zipDir(file, relativePath + f.getName() + "/", zos, false);
                continue;
            }
            ZipEntry anEntry = new ZipEntry(relativePath + f.getName());
            zos.putNextEntry(anEntry);
            FileInputStream is = new FileInputStream(f);
            byte[] arr = new byte[4096];
            int read = ((InputStream)is).read(arr);
            while (read > -1) {
                zos.write(arr, 0, read);
                read = ((InputStream)is).read(arr);
            }
            ((InputStream)is).close();
            zos.closeEntry();
        }
    }

    public static File createJar(File baseDir, String jarName, Class ... classes) throws IOException {
        File classesDir = new File(baseDir, "classes");
        for (Class clazz : classes) {
            String packagePath;
            File dir;
            String classPath;
            String classFileName = classPath = clazz.getName().replace(".", "/") + ".class";
            if (classPath.lastIndexOf("/") > -1) {
                classFileName = classPath.substring(classPath.lastIndexOf("/") + 1);
            }
            if (!(dir = new File(classesDir, packagePath = new File(classPath).getParent())).exists() && !dir.mkdirs()) {
                throw new IOException(XLog.format("could not create dir [{0}]", dir));
            }
            InputStream is = IOUtils.getResourceAsStream(classPath, -1);
            FileOutputStream os = new FileOutputStream(new File(dir, classFileName));
            IOUtils.copyStream(is, os);
        }
        File jar = new File(baseDir, jarName);
        File jarDir = jar.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(XLog.format("could not create dir [{0}]", jarDir));
        }
        JarOutputStream zos = new JarOutputStream((OutputStream)new FileOutputStream(jar), new Manifest());
        IOUtils.zipDir(classesDir, "", zos);
        return jar;
    }
}

