/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.oozie.util.PriorityDelayQueue;

public class PollablePriorityDelayQueue<E>
extends PriorityDelayQueue<E> {
    public PollablePriorityDelayQueue(int priorities, long maxWait, TimeUnit unit, int maxSize) {
        super(priorities, maxWait, unit, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PriorityDelayQueue.QueueElement<E> poll() {
        try {
            int i;
            this.lock.lock();
            this.antiStarvation();
            PriorityDelayQueue.QueueElement e = null;
            for (i = this.priorities; e == null && i > 0; --i) {
                e = (PriorityDelayQueue.QueueElement)this.queues[i - 1].peek();
                if (this.eligibleToPoll(e)) {
                    e = (PriorityDelayQueue.QueueElement)this.queues[i - 1].poll();
                    continue;
                }
                if (e != null) {
                    this.debug("poll(): the peek element [{0}], from P[{1}] is not eligible to poll", e.getElement().toString(), i);
                }
                e = null;
                Iterator iter = this.queues[i - 1].iterator();
                while (e == null && iter.hasNext()) {
                    e = (PriorityDelayQueue.QueueElement)iter.next();
                    if (this.eligibleToPoll(e)) {
                        this.queues[i - 1].remove(e);
                        continue;
                    }
                    this.debug("poll(): the iterator element [{0}], from P[{1}] is not eligible to poll", e.getElement().toString(), i);
                    e = null;
                }
            }
            if (e != null) {
                if (this.currentSize != null) {
                    this.currentSize.decrementAndGet();
                }
                e.inQueue = false;
                this.debug("poll(): [{0}], from P[{1}]", e.getElement().toString(), i);
            }
            PriorityDelayQueue.QueueElement queueElement = e;
            return queueElement;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean eligibleToPoll(PriorityDelayQueue.QueueElement<?> element) {
        return true;
    }
}

