/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.validation.Schema;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.store.OozieSchema;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.util.db.SqlStatement;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowLib;

public class DBLiteWorkflowLib
extends LiteWorkflowLib {
    private final Connection connection;

    public DBLiteWorkflowLib(Schema schema, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass, Connection connection) {
        super(schema, decisionHandlerClass, actionHandlerClass);
        this.connection = connection;
    }

    @Override
    public void insert(WorkflowInstance instance) throws WorkflowException {
        ParamChecker.notNull(instance, "instance");
        try {
            SqlStatement.insertInto(OozieSchema.OozieTable.WF_PROCESS_INSTANCE).value(OozieSchema.OozieColumn.PI_wfId, instance.getId()).value(OozieSchema.OozieColumn.PI_state, WritableUtils.toByteArray((LiteWorkflowInstance)instance)).prepareAndSetValues(this.connection).executeUpdate();
        }
        catch (SQLException e) {
            throw new WorkflowException(ErrorCode.E0713, e.getMessage(), e);
        }
    }

    @Override
    public WorkflowInstance get(String id) throws WorkflowException {
        ParamChecker.notNull(id, "id");
        try {
            SqlStatement.ResultSetReader rs = SqlStatement.parse(SqlStatement.selectColumns(OozieSchema.OozieColumn.PI_state).where(SqlStatement.isEqual(OozieSchema.OozieColumn.PI_wfId, ParamChecker.notNull(id, "id"))).prepareAndSetValues(this.connection).executeQuery());
            rs.next();
            LiteWorkflowInstance pInstance = WritableUtils.fromByteArray(rs.getByteArray(OozieSchema.OozieColumn.PI_state), LiteWorkflowInstance.class);
            return pInstance;
        }
        catch (SQLException e) {
            throw new WorkflowException(ErrorCode.E0713, e.getMessage(), e);
        }
    }

    @Override
    public void update(WorkflowInstance instance) throws WorkflowException {
        ParamChecker.notNull(instance, "instance");
        try {
            SqlStatement.update(OozieSchema.OozieTable.WF_PROCESS_INSTANCE).set(OozieSchema.OozieColumn.PI_state, WritableUtils.toByteArray((LiteWorkflowInstance)instance)).where(SqlStatement.isEqual(OozieSchema.OozieColumn.PI_wfId, instance.getId())).prepareAndSetValues(this.connection).executeUpdate();
        }
        catch (SQLException e) {
            throw new WorkflowException(ErrorCode.E0713, e.getMessage(), e);
        }
    }

    @Override
    public void delete(String id) throws WorkflowException {
        ParamChecker.notNull(id, "id");
        try {
            SqlStatement.deleteFrom(OozieSchema.OozieTable.WF_PROCESS_INSTANCE).where(SqlStatement.isEqual(OozieSchema.OozieColumn.PI_wfId, id)).prepareAndSetValues(this.connection).executeUpdate();
        }
        catch (SQLException e) {
            throw new WorkflowException(ErrorCode.E0713, e.getMessage(), e);
        }
    }

    @Override
    public void commit() throws WorkflowException {
    }

    @Override
    public void close() throws WorkflowException {
    }
}

