/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.SubQueryDiagnostic;
import org.apache.hadoop.hive.ql.plan.ExplainSQRewriteWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;

public class ExplainSQRewriteTask
extends Task<ExplainSQRewriteWork>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public StageType getType() {
        return StageType.EXPLAIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int n;
        PrintStream out = null;
        try {
            Path resFile = new Path(((ExplainSQRewriteWork)this.work).getResFile());
            FSDataOutputStream outS = resFile.getFileSystem((Configuration)this.conf).create(resFile);
            out = new PrintStream((OutputStream)outS);
            QB qb = ((ExplainSQRewriteWork)this.work).getQb();
            TokenRewriteStream stream = ((ExplainSQRewriteWork)this.work).getCtx().getTokenRewriteStream();
            String program = "sq rewrite";
            ASTNode ast = ((ExplainSQRewriteWork)this.work).getAst();
            try {
                this.addRewrites(stream, qb, program, out);
                out.println("\nRewritten Query:\n" + stream.toString(program, ast.getTokenStartIndex(), ast.getTokenStopIndex()));
            }
            finally {
                stream.deleteProgram(program);
            }
            out.close();
            out = null;
            n = 0;
        }
        catch (Exception e) {
            int n2;
            try {
                this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
                n2 = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
            return n2;
        }
        IOUtils.closeStream((Closeable)out);
        return n;
    }

    void addRewrites(TokenRewriteStream stream, QB qb, String program, PrintStream out) {
        QBSubQuery sqW = qb.getWhereClauseSubQueryPredicate();
        QBSubQuery sqH = qb.getHavingClauseSubQueryPredicate();
        if (sqW != null || sqH != null) {
            ASTNode sqNode = sqW != null ? sqW.getOriginalSubQueryASTForRewrite() : sqH.getOriginalSubQueryASTForRewrite();
            ASTNode tokQry = this.getQueryASTNode(sqNode);
            ASTNode tokFrom = (ASTNode)tokQry.getChild(0);
            StringBuilder addedJoins = new StringBuilder();
            if (sqW != null) {
                this.addRewrites(stream, sqW, program, out, qb.getId(), true, addedJoins);
            }
            if (sqH != null) {
                this.addRewrites(stream, sqH, program, out, qb.getId(), false, addedJoins);
            }
            stream.insertAfter(program, tokFrom.getTokenStopIndex(), (Object)addedJoins);
        }
        Set<String> sqAliases = qb.getSubqAliases();
        for (String sqAlias : sqAliases) {
            this.addRewrites(stream, qb.getSubqForAlias(sqAlias).getQB(), program, out);
        }
    }

    void addRewrites(TokenRewriteStream stream, QBSubQuery sq, String program, PrintStream out, String qbAlias, boolean isWhere, StringBuilder addedJoins) {
        String qualifier;
        ASTNode sqNode = sq.getOriginalSubQueryASTForRewrite();
        ASTNode tokQry = this.getQueryASTNode(sqNode);
        ASTNode tokInsert = (ASTNode)tokQry.getChild(1);
        ASTNode tokWhere = null;
        for (int i = 0; i < tokInsert.getChildCount(); ++i) {
            if (tokInsert.getChild(i).getType() != 905) continue;
            tokWhere = (ASTNode)tokInsert.getChild(i);
            break;
        }
        SubQueryDiagnostic.QBSubQueryRewrite diag = sq.getDiagnostic();
        String sqStr = diag.getRewrittenQuery();
        String joinCond = diag.getJoiningCondition();
        stream.replace(program, sqNode.getTokenStartIndex(), sqNode.getTokenStopIndex(), (Object)"1 = 1");
        String sqJoin = " " + this.getJoinKeyWord(sq) + " " + sqStr + " " + joinCond;
        addedJoins.append(" ").append(sqJoin);
        String postJoinCond = diag.getOuterQueryPostJoinCond();
        if (postJoinCond != null) {
            stream.insertAfter(program, tokWhere.getTokenStopIndex(), (Object)(" and " + postJoinCond));
        }
        String string = qualifier = isWhere ? "Where Clause " : "Having Clause ";
        if (qbAlias != null) {
            qualifier = qualifier + "for Query Block '" + qbAlias + "' ";
        }
        out.println(String.format("\n%s Rewritten SubQuery:\n%s", qualifier, diag.getRewrittenQuery()));
        out.println(String.format("\n%s SubQuery Joining Condition:\n%s", qualifier, diag.getJoiningCondition()));
    }

    private String getJoinKeyWord(QBSubQuery sq) {
        switch (sq.getJoinType()) {
            case LEFTOUTER: {
                return "left outer join";
            }
            case LEFTSEMI: {
                return "left semi join";
            }
            case RIGHTOUTER: {
                return "right outer join";
            }
            case FULLOUTER: {
                return "full outer join";
            }
        }
        return "inner join";
    }

    private ASTNode getQueryASTNode(ASTNode node) {
        while (node != null && node.getType() != 787) {
            node = (ASTNode)node.getParent();
        }
        return node;
    }

    @Override
    public String getName() {
        return "EXPLAIN REWRITE";
    }

    public List<FieldSchema> getResultSchema() {
        FieldSchema tmpFieldSchema = new FieldSchema();
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        tmpFieldSchema.setName("Explain");
        tmpFieldSchema.setType("string");
        colList.add(tmpFieldSchema);
        return colList;
    }
}

