/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;

public class ASTNode
extends CommonTree
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient StringBuilder astStr;
    private transient ASTNodeOrigin origin;
    private transient int startIndx = -1;
    private transient int endIndx = -1;
    private transient ASTNode rootNode;
    private transient boolean isValidASTStr;

    public ASTNode() {
    }

    public ASTNode(Token t) {
        super(t);
    }

    public ASTNode(ASTNode node) {
        super((CommonTree)node);
        this.origin = node.origin;
    }

    public Tree dupNode() {
        return new ASTNode(this);
    }

    public ArrayList<Node> getChildren() {
        if (super.getChildCount() == 0) {
            return null;
        }
        ArrayList<Node> ret_vec = new ArrayList<Node>();
        for (int i = 0; i < super.getChildCount(); ++i) {
            ret_vec.add((Node)super.getChild(i));
        }
        return ret_vec;
    }

    @Override
    public String getName() {
        return Integer.valueOf(super.getToken().getType()).toString();
    }

    public ASTNodeOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(ASTNodeOrigin origin) {
        this.origin = origin;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("\n");
        this.dump(sb, "");
        return sb.toString();
    }

    private StringBuilder dump(StringBuilder sb, String ws) {
        sb.append(ws);
        sb.append(this.toString());
        sb.append("\n");
        List children = this.getChildren();
        if (children != null) {
            for (Node node : this.getChildren()) {
                if (node instanceof ASTNode) {
                    ((ASTNode)node).dump(sb, ws + "   ");
                    continue;
                }
                sb.append(ws);
                sb.append("   NON-ASTNODE!!");
                sb.append("\n");
            }
        }
        return sb;
    }

    private void getRootNodeWithValidASTStr() {
        if (this.rootNode != null && this.rootNode.parent == null && this.rootNode.hasValidMemoizedString()) {
            return;
        }
        ASTNode retNode = this;
        while (retNode.parent != null) {
            retNode = (ASTNode)retNode.parent;
        }
        this.rootNode = retNode;
        if (!this.rootNode.isValidASTStr) {
            this.rootNode.astStr = new StringBuilder();
            this.rootNode.toStringTree(this.rootNode);
            this.rootNode.isValidASTStr = true;
        }
    }

    private boolean hasValidMemoizedString() {
        return this.isValidASTStr && this.astStr != null;
    }

    private void resetRootInformation() {
        if (this.rootNode != null) {
            this.rootNode.astStr = null;
            this.rootNode.isValidASTStr = false;
        }
    }

    private int getMemoizedStringLen() {
        return this.astStr == null ? 0 : this.astStr.length();
    }

    private String getMemoizedSubString(int start, int end) {
        return this.astStr == null || start < 0 || end > this.astStr.length() || start >= end ? null : this.astStr.subSequence(start, end).toString();
    }

    private void addtoMemoizedString(String string) {
        if (this.astStr == null) {
            this.astStr = new StringBuilder();
        }
        this.astStr.append(string);
    }

    public void setParent(Tree t) {
        super.setParent(t);
        this.resetRootInformation();
    }

    public void addChild(Tree t) {
        super.addChild(t);
        this.resetRootInformation();
    }

    public void addChildren(List kids) {
        super.addChildren(kids);
        this.resetRootInformation();
    }

    public void setChild(int i, Tree t) {
        super.setChild(i, t);
        this.resetRootInformation();
    }

    public void insertChild(int i, Object t) {
        super.insertChild(i, t);
        this.resetRootInformation();
    }

    public Object deleteChild(int i) {
        Object ret = super.deleteChild(i);
        this.resetRootInformation();
        return ret;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        super.replaceChildren(startChildIndex, stopChildIndex, t);
        this.resetRootInformation();
    }

    public String toStringTree() {
        this.getRootNodeWithValidASTStr();
        if (this.startIndx >= 0 && this.endIndx <= this.rootNode.getMemoizedStringLen()) {
            return this.rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
        }
        return this.toStringTree(this.rootNode);
    }

    private String toStringTree(ASTNode rootNode) {
        this.rootNode = rootNode;
        this.startIndx = rootNode.getMemoizedStringLen();
        if (this.children == null || this.children.size() == 0) {
            String str = this.toString();
            rootNode.addtoMemoizedString(this.getType() != 307 ? str.toLowerCase() : str);
            this.endIndx = rootNode.getMemoizedStringLen();
            return this.getType() != 307 ? str.toLowerCase() : str;
        }
        if (!this.isNil()) {
            rootNode.addtoMemoizedString("(");
            String str = this.toString();
            rootNode.addtoMemoizedString(this.getType() == 307 || null == str ? str : str.toLowerCase());
            rootNode.addtoMemoizedString(" ");
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            ASTNode t = (ASTNode)this.children.get(i);
            if (i > 0) {
                rootNode.addtoMemoizedString(" ");
            }
            t.toStringTree(rootNode);
        }
        if (!this.isNil()) {
            rootNode.addtoMemoizedString(")");
        }
        this.endIndx = rootNode.getMemoizedStringLen();
        return rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
    }
}

