/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.mapred.InputFormat;

public class ProcessAnalyzeTable
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)ProcessAnalyzeTable.class.getName());
    private GenTezUtils utils = null;

    public ProcessAnalyzeTable(GenTezUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        GenTezProcContext context = (GenTezProcContext)procContext;
        TableScanOperator tableScan = (TableScanOperator)nd;
        ParseContext parseContext = context.parseContext;
        Class<? extends InputFormat> inputFormat = ((TableScanDesc)tableScan.getConf()).getTableMetadata().getInputFormatClass();
        QB queryBlock = parseContext.getQB();
        QBParseInfo parseInfo = parseContext.getQB().getParseInfo();
        if (parseInfo.isAnalyzeCommand()) {
            assert (tableScan.getChildOperators() == null || tableScan.getChildOperators().size() == 0);
            String alias = null;
            for (String a : parseContext.getTopOps().keySet()) {
                if (tableScan != parseContext.getTopOps().get(a)) continue;
                alias = a;
            }
            assert (alias != null);
            TezWork tezWork = (TezWork)context.currentTask.getWork();
            boolean partialScan = parseInfo.isPartialScanAnalyzeCommand();
            boolean noScan = parseInfo.isNoScanAnalyzeCommand();
            if (inputFormat.equals(OrcInputFormat.class) && (noScan || partialScan)) {
                StatsNoJobWork snjWork = new StatsNoJobWork(parseContext.getQB().getParseInfo().getTableSpec());
                snjWork.setStatsReliable(parseContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                Task<StatsNoJobWork> snjTask = TaskFactory.get(snjWork, parseContext.getConf(), new Task[0]);
                snjTask.setParentTasks(null);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(snjTask);
                return true;
            }
            StatsWork statsWork = new StatsWork(parseInfo.getTableSpec());
            statsWork.setAggKey(((TableScanDesc)tableScan.getConf()).getStatsAggPrefix());
            statsWork.setStatsTmpDir(((TableScanDesc)tableScan.getConf()).getTmpStatsDir());
            statsWork.setSourceTask(context.currentTask);
            statsWork.setStatsReliable(parseContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            Task<StatsWork> statsTask = TaskFactory.get(statsWork, parseContext.getConf(), new Task[0]);
            context.currentTask.addDependentTask(statsTask);
            if (parseInfo.isNoScanAnalyzeCommand()) {
                statsTask.setParentTasks(null);
                statsWork.setNoScanAnalyzeCommand(true);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(statsTask);
            }
            if (parseInfo.isPartialScanAnalyzeCommand()) {
                this.handlePartialScanCommand(tableScan, parseContext, parseInfo, statsWork, context, statsTask);
            }
            Set<Partition> confirmedPartns = GenMapRedUtils.getConfirmedPartitionsForScan(parseInfo);
            PrunedPartitionList partitions = null;
            if (confirmedPartns.size() > 0) {
                Table source = queryBlock.getMetaData().getTableForAlias(alias);
                List<String> partCols = GenMapRedUtils.getPartitionColumns(parseInfo);
                partitions = new PrunedPartitionList(source, confirmedPartns, partCols, false);
            }
            MapWork w = this.utils.createMapWork(context, tableScan, tezWork, partitions);
            w.setGatheringStats(true);
            return true;
        }
        return null;
    }

    private void handlePartialScanCommand(TableScanOperator tableScan, ParseContext parseContext, QBParseInfo parseInfo, StatsWork statsWork, GenTezProcContext context, Task<StatsWork> statsTask) throws SemanticException {
        String aggregationKey = ((TableScanDesc)tableScan.getConf()).getStatsAggPrefix();
        StringBuffer aggregationKeyBuffer = new StringBuffer(aggregationKey);
        List<Path> inputPaths = GenMapRedUtils.getInputPathsForPartialScan(parseInfo, aggregationKeyBuffer);
        aggregationKey = aggregationKeyBuffer.toString();
        PartialScanWork scanWork = new PartialScanWork(inputPaths);
        scanWork.setMapperCannotSpanPartns(true);
        scanWork.setAggKey(aggregationKey);
        scanWork.setStatsTmpDir(((TableScanDesc)tableScan.getConf()).getTmpStatsDir(), parseContext.getConf());
        statsWork.setPartialScanAnalyzeCommand(true);
        DriverContext driverCxt = new DriverContext();
        Task<PartialScanWork> partialScanTask = TaskFactory.get(scanWork, parseContext.getConf(), new Task[0]);
        partialScanTask.initialize(parseContext.getConf(), null, driverCxt);
        partialScanTask.setWork(scanWork);
        statsWork.setSourceTask(partialScanTask);
        context.rootTasks.remove(context.currentTask);
        context.rootTasks.add(partialScanTask);
        partialScanTask.addDependentTask(statsTask);
    }
}

