/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import shaded.parquet.org.codehaus.jackson.JsonGenerator;
import shaded.parquet.org.codehaus.jackson.JsonNode;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.JsonSerializer;
import shaded.parquet.org.codehaus.jackson.map.SerializerProvider;
import shaded.parquet.org.codehaus.jackson.map.ser.SerializerBase;
import shaded.parquet.org.codehaus.jackson.map.ser.StdSerializers;
import shaded.parquet.org.codehaus.jackson.map.ser.ToStringSerializer;
import shaded.parquet.org.codehaus.jackson.map.util.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreXMLSerializers
implements Provider<Map.Entry<Class<?>, JsonSerializer<?>>> {
    static final HashMap<Class<?>, JsonSerializer<?>> _serializers = new HashMap();

    @Override
    public Collection<Map.Entry<Class<?>, JsonSerializer<?>>> provide() {
        return _serializers.entrySet();
    }

    static {
        ToStringSerializer tss = ToStringSerializer.instance;
        _serializers.put(Duration.class, tss);
        _serializers.put(XMLGregorianCalendar.class, new XMLGregorianCalendarSerializer());
        _serializers.put(QName.class, tss);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLGregorianCalendarSerializer
    extends SerializerBase<XMLGregorianCalendar> {
        public XMLGregorianCalendarSerializer() {
            super(XMLGregorianCalendar.class);
        }

        @Override
        public void serialize(XMLGregorianCalendar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            StdSerializers.CalendarSerializer.instance.serialize(value.toGregorianCalendar(), jgen, provider);
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
            return StdSerializers.CalendarSerializer.instance.getSchema(provider, typeHint);
        }
    }
}

