/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RpcScheduler;
import org.apache.hadoop.ipc.Schedulable;

public class CallQueueManager<E> {
    public static final Log LOG = LogFactory.getLog(CallQueueManager.class);
    private static final int CHECKPOINT_NUM = 20;
    private static final long CHECKPOINT_INTERVAL_MS = 10L;
    private volatile boolean clientBackOffEnabled;
    private final AtomicReference<BlockingQueue<E>> putRef;
    private final AtomicReference<BlockingQueue<E>> takeRef;
    private RpcScheduler scheduler;

    static <E> Class<? extends BlockingQueue<E>> convertQueueClass(Class<?> queueClass, Class<E> elementClass) {
        return queueClass;
    }

    static Class<? extends RpcScheduler> convertSchedulerClass(Class<?> schedulerClass) {
        return schedulerClass;
    }

    public CallQueueManager(Class<? extends BlockingQueue<E>> backingClass, Class<? extends RpcScheduler> schedulerClass, boolean clientBackOffEnabled, int maxQueueSize, String namespace, Configuration conf) {
        int priorityLevels = CallQueueManager.parseNumLevels(namespace, conf);
        this.scheduler = CallQueueManager.createScheduler(schedulerClass, priorityLevels, namespace, conf);
        BlockingQueue<E> bq = this.createCallQueueInstance(backingClass, priorityLevels, maxQueueSize, namespace, conf);
        this.clientBackOffEnabled = clientBackOffEnabled;
        this.putRef = new AtomicReference<BlockingQueue<E>>(bq);
        this.takeRef = new AtomicReference<BlockingQueue<E>>(bq);
        LOG.info((Object)("Using callQueue: " + backingClass + " scheduler: " + schedulerClass));
    }

    private static <T extends RpcScheduler> T createScheduler(Class<T> theClass, int priorityLevels, String ns, Configuration conf) {
        try {
            Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE, String.class, Configuration.class);
            return (T)((RpcScheduler)ctor.newInstance(priorityLevels, ns, conf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(theClass.getName() + " could not be constructed.", e.getCause());
        }
        catch (Exception e) {
            try {
                Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE);
                return (T)((RpcScheduler)ctor.newInstance(priorityLevels));
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException(theClass.getName() + " could not be constructed.", e3.getCause());
            }
            catch (Exception e4) {
                try {
                    Constructor<T> ctor = theClass.getDeclaredConstructor(new Class[0]);
                    return (T)((RpcScheduler)ctor.newInstance(new Object[0]));
                }
                catch (RuntimeException e5) {
                    throw e5;
                }
                catch (InvocationTargetException e6) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.", e6.getCause());
                }
                catch (Exception e7) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.");
                }
            }
        }
    }

    private <T extends BlockingQueue<E>> T createCallQueueInstance(Class<T> theClass, int priorityLevels, int maxLen, String ns, Configuration conf) {
        try {
            Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, String.class, Configuration.class);
            return (T)((BlockingQueue)ctor.newInstance(priorityLevels, maxLen, ns, conf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(theClass.getName() + " could not be constructed.", e.getCause());
        }
        catch (Exception e) {
            try {
                Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE);
                return (T)((BlockingQueue)ctor.newInstance(maxLen));
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException(theClass.getName() + " could not be constructed.", e3.getCause());
            }
            catch (Exception e4) {
                try {
                    Constructor<T> ctor = theClass.getDeclaredConstructor(new Class[0]);
                    return (T)((BlockingQueue)ctor.newInstance(new Object[0]));
                }
                catch (RuntimeException e5) {
                    throw e5;
                }
                catch (InvocationTargetException e6) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.", e6.getCause());
                }
                catch (Exception e7) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.");
                }
            }
        }
    }

    boolean isClientBackoffEnabled() {
        return this.clientBackOffEnabled;
    }

    boolean shouldBackOff(Schedulable e) {
        return this.scheduler.shouldBackOff(e);
    }

    void addResponseTime(String name, int priorityLevel, int queueTime, int processingTime) {
        this.scheduler.addResponseTime(name, priorityLevel, queueTime, processingTime);
    }

    int getPriorityLevel(Schedulable e) {
        return this.scheduler.getPriorityLevel(e);
    }

    void setClientBackoffEnabled(boolean value) {
        this.clientBackOffEnabled = value;
    }

    public void put(E e) throws InterruptedException {
        this.putRef.get().put(e);
    }

    public boolean offer(E e) throws InterruptedException {
        return this.putRef.get().offer(e);
    }

    public E take() throws InterruptedException {
        E e = null;
        while (e == null) {
            e = this.takeRef.get().poll(1000L, TimeUnit.MILLISECONDS);
        }
        return e;
    }

    public int size() {
        return this.takeRef.get().size();
    }

    private static int parseNumLevels(String ns, Configuration conf) {
        int retval = conf.getInt(ns + "." + "faircallqueue.priority-levels", 0);
        if (retval == 0) {
            retval = conf.getInt(ns + "." + "scheduler.priority.levels", 4);
        } else {
            LOG.warn((Object)(ns + "." + "faircallqueue.priority-levels" + " is deprecated. Please use " + ns + "." + "scheduler.priority.levels" + "."));
        }
        if (retval < 1) {
            throw new IllegalArgumentException("numLevels must be at least 1");
        }
        return retval;
    }

    public synchronized void swapQueue(Class<? extends RpcScheduler> schedulerClass, Class<? extends BlockingQueue<E>> queueClassToUse, int maxSize, String ns, Configuration conf) {
        int priorityLevels = CallQueueManager.parseNumLevels(ns, conf);
        RpcScheduler newScheduler = CallQueueManager.createScheduler(schedulerClass, priorityLevels, ns, conf);
        BlockingQueue<E> newQ = this.createCallQueueInstance(queueClassToUse, priorityLevels, maxSize, ns, conf);
        BlockingQueue<E> oldQ = this.putRef.get();
        this.putRef.set(newQ);
        while (!this.queueIsReallyEmpty(oldQ)) {
        }
        this.takeRef.set(newQ);
        this.scheduler = newScheduler;
        LOG.info((Object)("Old Queue: " + this.stringRepr(oldQ) + ", " + "Replacement: " + this.stringRepr(newQ)));
    }

    private boolean queueIsReallyEmpty(BlockingQueue<?> q) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                return false;
            }
            if (q.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String stringRepr(Object o) {
        return o.getClass().getName() + '@' + Integer.toHexString(o.hashCode());
    }
}

