/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MuxDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class MuxOperator
extends Operator<MuxDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog((String)MuxOperator.class.getName());
    private transient ObjectInspector[] outputObjectInspectors;
    private transient int numParents;
    private transient boolean[] forward;
    private transient boolean[] processGroupCalled;
    private Handler[] handlers;
    private transient long[] cntrs;
    private transient long[] nextCntrs;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        if (this.childOperatorsArray.length != 1) {
            throw new HiveException("Expected number of children is 1. Found : " + this.childOperatorsArray.length);
        }
        this.numParents = this.getNumParent();
        this.forward = new boolean[this.numParents];
        this.processGroupCalled = new boolean[this.numParents];
        this.outputObjectInspectors = new ObjectInspector[this.numParents];
        this.handlers = new Handler[this.numParents];
        this.cntrs = new long[this.numParents];
        this.nextCntrs = new long[this.numParents];
        for (int i = 0; i < this.numParents; ++i) {
            this.processGroupCalled[i] = false;
            if (((MuxDesc)this.conf).getParentToKeyCols().get(i) == null) {
                this.handlers[i] = null;
                this.forward[i] = true;
                this.outputObjectInspectors[i] = this.inputObjInspectors[i];
            } else {
                this.handlers[i] = new Handler(this.inputObjInspectors[i], ((MuxDesc)this.conf).getParentToKeyCols().get(i), ((MuxDesc)this.conf).getParentToValueCols().get(i), ((MuxDesc)this.conf).getParentToOutputKeyColumnNames().get(i), ((MuxDesc)this.conf).getParentToOutputValueColumnNames().get(i), ((MuxDesc)this.conf).getParentToTag().get(i));
                this.forward[i] = false;
                this.outputObjectInspectors[i] = this.handlers[i].getOutputObjInspector();
            }
            this.cntrs[i] = 0L;
            this.nextCntrs[i] = 1L;
        }
        this.initializeChildren(hconf);
    }

    @Override
    protected void initializeChildren(Configuration hconf) throws HiveException {
        this.state = Operator.State.INIT;
        LOG.info((Object)("Operator " + this.id + " " + this.getName() + " initialized"));
        if (this.childOperators == null || this.childOperators.isEmpty()) {
            return;
        }
        LOG.info((Object)("Initializing children of " + this.id + " " + this.getName()));
        this.childOperatorsArray[0].initialize(hconf, this.outputObjectInspectors);
        if (this.reporter != null) {
            this.childOperatorsArray[0].setReporter(this.reporter);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.isLogInfoEnabled) {
            int n = tag;
            this.cntrs[n] = this.cntrs[n] + 1L;
            if (this.cntrs[tag] == this.nextCntrs[tag]) {
                LOG.info((Object)(this.id + ", tag=" + tag + ", forwarding " + this.cntrs[tag] + " rows"));
                this.nextCntrs[tag] = this.getNextCntr(this.cntrs[tag]);
            }
        }
        int childrenDone = 0;
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            Operator child = this.childOperatorsArray[i];
            if (child.getDone()) {
                ++childrenDone;
                continue;
            }
            if (this.forward[tag]) {
                child.processOp(row, tag);
                continue;
            }
            child.processOp(this.handlers[tag].process(row), this.handlers[tag].getTag());
        }
        if (childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    @Override
    public void forward(Object row, ObjectInspector rowInspector) throws HiveException {
    }

    @Override
    public void startGroup() throws HiveException {
        for (int i = 0; i < this.numParents; ++i) {
            this.processGroupCalled[i] = false;
        }
        super.startGroup();
    }

    @Override
    public void endGroup() throws HiveException {
    }

    @Override
    public void processGroup(int tag) throws HiveException {
        this.processGroupCalled[tag] = true;
        boolean shouldProceed = true;
        for (int i = 0; i < this.numParents; ++i) {
            if (this.processGroupCalled[i]) continue;
            shouldProceed = false;
            break;
        }
        if (shouldProceed) {
            Operator child = this.childOperatorsArray[0];
            int childTag = this.childOperatorsTag[0];
            child.flush();
            child.endGroup();
            child.processGroup(childTag);
        }
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        for (int i = 0; i < this.numParents; ++i) {
            LOG.info((Object)(this.id + ", tag=" + i + ", forwarded " + this.cntrs[i] + " rows"));
        }
    }

    @Override
    public String getName() {
        return MuxOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MUX";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MUX;
    }

    protected static class Handler {
        private final ObjectInspector outputObjInspector;
        private final int tag;
        private final ExprNodeEvaluator[] keyEval;
        private final ExprNodeEvaluator[] valueEval;
        private final Object[] outputKey;
        private final Object[] outputValue;
        private final List<Object> forwardedRow;

        public Handler(ObjectInspector inputObjInspector, List<ExprNodeDesc> keyCols, List<ExprNodeDesc> valueCols, List<String> outputKeyColumnNames, List<String> outputValueColumnNames, Integer tag) throws HiveException {
            this.keyEval = new ExprNodeEvaluator[keyCols.size()];
            int i = 0;
            for (ExprNodeDesc e : keyCols) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.outputKey = new Object[this.keyEval.length];
            this.valueEval = new ExprNodeEvaluator[valueCols.size()];
            i = 0;
            for (ExprNodeDesc e : valueCols) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.outputValue = new Object[this.valueEval.length];
            this.tag = tag;
            StructObjectInspector keyObjectInspector = Operator.initEvaluatorsAndReturnStruct(this.keyEval, outputKeyColumnNames, inputObjInspector);
            StructObjectInspector valueObjectInspector = Operator.initEvaluatorsAndReturnStruct(this.valueEval, outputValueColumnNames, inputObjInspector);
            ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
            ois.add(keyObjectInspector);
            ois.add(valueObjectInspector);
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, ois);
            this.forwardedRow = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
        }

        public ObjectInspector getOutputObjInspector() {
            return this.outputObjInspector;
        }

        public int getTag() {
            return this.tag;
        }

        public Object process(Object row) throws HiveException {
            int i;
            for (i = 0; i < this.keyEval.length; ++i) {
                this.outputKey[i] = this.keyEval[i].evaluate(row);
            }
            for (i = 0; i < this.valueEval.length; ++i) {
                this.outputValue[i] = this.valueEval[i].evaluate(row);
            }
            this.forwardedRow.clear();
            this.forwardedRow.add(Arrays.asList(this.outputKey));
            this.forwardedRow.add(Arrays.asList(this.outputValue));
            return this.forwardedRow;
        }
    }
}

