/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class Operator<T extends OperatorDesc>
implements Serializable,
Cloneable,
Node {
    private static final long serialVersionUID = 1L;
    public static final String HIVECOUNTERCREATEDFILES = "CREATED_FILES";
    public static final String HIVECOUNTERFATAL = "FATAL_ERROR";
    public static final String CONTEXT_NAME_KEY = "__hive.context.name";
    private transient Configuration configuration;
    protected List<Operator<? extends OperatorDesc>> childOperators;
    protected List<Operator<? extends OperatorDesc>> parentOperators;
    protected String operatorId;
    private transient ExecMapperContext execContext;
    private static AtomicInteger seqId = new AtomicInteger(0);
    protected transient State state = State.UNINIT;
    private boolean useBucketizedHiveInputFormat;
    protected T conf;
    protected boolean done;
    private RowSchema rowSchema;
    protected transient Map<String, LongWritable> statsMap = new HashMap<String, LongWritable>();
    protected transient OutputCollector out;
    protected final transient Log LOG = LogFactory.getLog((String)this.getClass().getName());
    protected final transient Log PLOG = LogFactory.getLog((String)Operator.class.getName());
    protected final transient boolean isLogInfoEnabled = this.LOG.isInfoEnabled() && this.PLOG.isInfoEnabled();
    protected final transient boolean isLogDebugEnabled = this.LOG.isDebugEnabled() && this.PLOG.isDebugEnabled();
    protected final transient boolean isLogTraceEnabled = this.LOG.isTraceEnabled() && this.PLOG.isTraceEnabled();
    protected transient String alias;
    protected transient Reporter reporter;
    protected transient String id;
    protected transient ObjectInspector[] inputObjInspectors = new ObjectInspector[1];
    protected transient ObjectInspector outputObjInspector;
    protected Map<String, ExprNodeDesc> colExprMap;
    private boolean jobCloseDone = false;
    protected transient Operator<? extends OperatorDesc>[] childOperatorsArray = null;
    protected transient int[] childOperatorsTag;
    protected transient Object groupKeyObject;

    private Operator(String name) {
        this.id = name;
    }

    public Operator() {
        this.id = String.valueOf(seqId.getAndIncrement());
        this.childOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        this.parentOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        this.initOperatorId();
    }

    public static void resetId() {
        seqId.set(0);
    }

    public Operator(Reporter reporter) {
        this();
        this.reporter = reporter;
    }

    public void setChildOperators(List<Operator<? extends OperatorDesc>> childOperators) {
        if (childOperators == null) {
            childOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        }
        this.childOperators = childOperators;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<Operator<? extends OperatorDesc>> getChildOperators() {
        return this.childOperators;
    }

    public int getNumChild() {
        return this.childOperators == null ? 0 : this.childOperators.size();
    }

    public ArrayList<Node> getChildren() {
        if (this.getChildOperators() == null) {
            return null;
        }
        ArrayList<Node> ret_vec = new ArrayList<Node>();
        for (Operator<OperatorDesc> op : this.getChildOperators()) {
            ret_vec.add(op);
        }
        return ret_vec;
    }

    public void setParentOperators(List<Operator<? extends OperatorDesc>> parentOperators) {
        if (parentOperators == null) {
            parentOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        }
        this.parentOperators = parentOperators;
    }

    public List<Operator<? extends OperatorDesc>> getParentOperators() {
        return this.parentOperators;
    }

    public int getNumParent() {
        return this.parentOperators == null ? 0 : this.parentOperators.size();
    }

    public void setConf(T conf) {
        this.conf = conf;
    }

    @Explain
    public T getConf() {
        return this.conf;
    }

    public boolean getDone() {
        return this.done;
    }

    protected final void setDone(boolean done) {
        this.done = done;
    }

    public void setSchema(RowSchema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public RowSchema getSchema() {
        return this.rowSchema;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.id;
    }

    public void setReporter(Reporter rep) {
        this.reporter = rep;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setReporter(rep);
        }
    }

    public void setOutputCollector(OutputCollector out) {
        this.out = out;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setOutputCollector(out);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setAlias(alias);
        }
    }

    public Map<String, Long> getStats() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (String one : this.statsMap.keySet()) {
            ret.put(one, this.statsMap.get(one).get());
        }
        return ret;
    }

    protected boolean areAllParentsInitialized() {
        if (this.parentOperators == null) {
            return true;
        }
        for (Operator<? extends OperatorDesc> parent : this.parentOperators) {
            if (parent == null || parent.state == State.INIT) continue;
            return false;
        }
        return true;
    }

    public void initialize(Configuration hconf, ObjectInspector[] inputOIs) throws HiveException {
        if (this.state == State.INIT) {
            return;
        }
        this.configuration = hconf;
        if (!this.areAllParentsInitialized()) {
            return;
        }
        this.LOG.info((Object)("Initializing Self " + this));
        if (inputOIs != null) {
            this.inputObjInspectors = inputOIs;
        }
        if (this.childOperators != null && !this.childOperators.isEmpty()) {
            int i;
            this.childOperatorsArray = new Operator[this.childOperators.size()];
            for (i = 0; i < this.childOperatorsArray.length; ++i) {
                this.childOperatorsArray[i] = this.childOperators.get(i);
            }
            this.childOperatorsTag = new int[this.childOperatorsArray.length];
            for (i = 0; i < this.childOperatorsArray.length; ++i) {
                List<Operator<OperatorDesc>> parentOperators = this.childOperatorsArray[i].getParentOperators();
                if (parentOperators == null) {
                    throw new HiveException("Hive internal error: parent is null in " + this.childOperatorsArray[i].getClass() + "!");
                }
                this.childOperatorsTag[i] = parentOperators.indexOf(this);
                if (this.childOperatorsTag[i] != -1) continue;
                throw new HiveException("Hive internal error: cannot find parent in the child operator!");
            }
        }
        if (this.inputObjInspectors.length == 0) {
            throw new HiveException("Internal Error during operator initialization.");
        }
        this.outputObjInspector = this.inputObjInspectors[0];
        this.passExecContext(this.execContext);
        this.initializeOp(hconf);
        if (this.childOperatorsArray == null && this.childOperators != null && !this.childOperators.isEmpty()) {
            throw new HiveException("Internal Hive error during operator initialization.");
        }
        this.LOG.info((Object)("Initialization Done " + this.id + " " + this.getName()));
    }

    public void initializeLocalWork(Configuration hconf) throws HiveException {
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends OperatorDesc> childOp = this.childOperators.get(i);
                childOp.initializeLocalWork(hconf);
            }
        }
    }

    protected void initializeOp(Configuration hconf) throws HiveException {
        this.initializeChildren(hconf);
    }

    protected void initializeChildren(Configuration hconf) throws HiveException {
        this.state = State.INIT;
        this.LOG.info((Object)("Operator " + this.id + " " + this.getName() + " initialized"));
        if (this.childOperators == null || this.childOperators.isEmpty()) {
            return;
        }
        this.LOG.info((Object)("Initializing children of " + this.id + " " + this.getName()));
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            this.childOperatorsArray[i].initialize(hconf, this.outputObjInspector, this.childOperatorsTag[i]);
            if (this.reporter == null) continue;
            this.childOperatorsArray[i].setReporter(this.reporter);
        }
    }

    public void passExecContext(ExecMapperContext execContext) {
        this.setExecContext(execContext);
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                this.childOperators.get(i).passExecContext(execContext);
            }
        }
    }

    protected void initialize(Configuration hconf, ObjectInspector inputOI, int parentId) throws HiveException {
        this.LOG.info((Object)("Initializing child " + this.id + " " + this.getName()));
        if (parentId >= this.inputObjInspectors.length) {
            int newLength;
            for (newLength = this.inputObjInspectors.length * 2; parentId >= newLength; newLength *= 2) {
            }
            this.inputObjInspectors = Arrays.copyOf(this.inputObjInspectors, newLength);
        }
        this.inputObjInspectors[parentId] = inputOI;
        this.initialize(hconf, null);
    }

    public ObjectInspector[] getInputObjInspectors() {
        return this.inputObjInspectors;
    }

    public void setInputObjInspectors(ObjectInspector[] inputObjInspectors) {
        this.inputObjInspectors = inputObjInspectors;
    }

    public ObjectInspector getOutputObjInspector() {
        return this.outputObjInspector;
    }

    public abstract void processOp(Object var1, int var2) throws HiveException;

    protected final void defaultStartGroup() throws HiveException {
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"Starting group");
        }
        if (this.childOperators == null) {
            return;
        }
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"Starting group for children:");
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.startGroup();
        }
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"Start group Done");
        }
    }

    protected final void defaultEndGroup() throws HiveException {
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"Ending group");
        }
        if (this.childOperators == null) {
            return;
        }
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"Ending group for children:");
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.endGroup();
        }
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)"End group Done");
        }
    }

    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    public void flush() throws HiveException {
    }

    public void processGroup(int tag) throws HiveException {
        if (this.childOperators == null || this.childOperators.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            this.childOperatorsArray[i].processGroup(this.childOperatorsTag[i]);
        }
    }

    protected boolean allInitializedParentsAreClosed() {
        if (this.parentOperators != null) {
            for (Operator<? extends OperatorDesc> parent : this.parentOperators) {
                if (parent == null) continue;
                this.LOG.debug((Object)("allInitializedParentsAreClosed? parent.state = " + (Object)((Object)parent.state)));
                if (parent.state == State.CLOSE || parent.state == State.UNINIT) continue;
                return false;
            }
        }
        return true;
    }

    public void close(boolean abort) throws HiveException {
        if (this.state == State.CLOSE) {
            return;
        }
        if (!this.allInitializedParentsAreClosed()) {
            this.LOG.debug((Object)"Not all parent operators are closed. Not closing.");
            return;
        }
        this.state = State.CLOSE;
        this.LOG.info((Object)(this.id + " finished. closing... "));
        this.closeOp(abort);
        this.reporter = null;
        try {
            this.logStats();
            if (this.childOperators == null) {
                return;
            }
            for (Operator<? extends OperatorDesc> op : this.childOperators) {
                this.LOG.debug((Object)("Closing child = " + op));
                op.close(abort);
            }
            this.LOG.info((Object)(this.id + " Close done"));
        }
        catch (HiveException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void closeOp(boolean abort) throws HiveException {
    }

    public void jobCloseOp(Configuration conf, boolean success) throws HiveException {
    }

    public void jobClose(Configuration conf, boolean success) throws HiveException {
        if (this.jobCloseDone) {
            return;
        }
        this.jobCloseOp(conf, success);
        this.jobCloseDone = true;
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> op : this.childOperators) {
                op.jobClose(conf, success);
            }
        }
    }

    public void replaceChild(Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> newChild) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        this.childOperators.set(childIndex, newChild);
    }

    public void removeChild(Operator<? extends OperatorDesc> child) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        if (this.childOperators.size() == 1) {
            this.setChildOperators(null);
        } else {
            this.childOperators.remove(childIndex);
        }
        int parentIndex = child.getParentOperators().indexOf(this);
        assert (parentIndex != -1);
        if (child.getParentOperators().size() == 1) {
            child.setParentOperators(null);
        } else {
            child.getParentOperators().remove(parentIndex);
        }
    }

    public void removeChildAndAdoptItsChildren(Operator<? extends OperatorDesc> child) throws SemanticException {
        int childIndex = this.childOperators.indexOf(child);
        if (childIndex == -1) {
            throw new SemanticException("Exception when trying to remove partition predicates: fail to find child from parent");
        }
        this.childOperators.remove(childIndex);
        if (child.getChildOperators() != null && child.getChildOperators().size() > 0) {
            this.childOperators.addAll(childIndex, child.getChildOperators());
        }
        for (Operator<OperatorDesc> gc : child.getChildOperators()) {
            List<Operator<OperatorDesc>> parents = gc.getParentOperators();
            int index = parents.indexOf(child);
            if (index == -1) {
                throw new SemanticException("Exception when trying to remove partition predicates: fail to find parent from child");
            }
            parents.set(index, this);
        }
    }

    public void removeParent(Operator<? extends OperatorDesc> parent) {
        int parentIndex = this.parentOperators.indexOf(parent);
        assert (parentIndex != -1);
        if (this.parentOperators.size() == 1) {
            this.setParentOperators(null);
        } else {
            this.parentOperators.remove(parentIndex);
        }
        int childIndex = parent.getChildOperators().indexOf(this);
        assert (childIndex != -1);
        if (parent.getChildOperators().size() == 1) {
            parent.setChildOperators(null);
        } else {
            parent.getChildOperators().remove(childIndex);
        }
    }

    public boolean removeChildren(int depth) {
        Operator<OperatorDesc> currOp = this;
        for (int i = 0; i < depth; ++i) {
            if (currOp.getChildOperators() == null || currOp.getChildOperators().isEmpty() || currOp.getChildOperators().size() > 1) {
                return false;
            }
            currOp = currOp.getChildOperators().get(0);
        }
        this.setChildOperators(currOp.getChildOperators());
        ArrayList<Operator<? extends OperatorDesc>> parentOps = new ArrayList<Operator<? extends OperatorDesc>>();
        parentOps.add(this);
        for (Operator<OperatorDesc> op : currOp.getChildOperators()) {
            op.setParentOperators(parentOps);
        }
        return true;
    }

    public void replaceParent(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> newParent) {
        int parentIndex = this.parentOperators.indexOf(parent);
        assert (parentIndex != -1);
        this.parentOperators.set(parentIndex, newParent);
    }

    protected long getNextCntr(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    protected void forward(Object row, ObjectInspector rowInspector) throws HiveException {
        if (this.childOperatorsArray == null || this.getDone()) {
            return;
        }
        int childrenDone = 0;
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            Operator<? extends OperatorDesc> o = this.childOperatorsArray[i];
            if (o.getDone()) {
                ++childrenDone;
                continue;
            }
            o.processOp(row, this.childOperatorsTag[i]);
        }
        if (childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    public void resetStats() {
        for (String e : this.statsMap.keySet()) {
            this.statsMap.get(e).set(0L);
        }
    }

    public void reset() {
        this.state = State.INIT;
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                o.reset();
            }
        }
    }

    public void preorderMap(OperatorFunc opFunc) {
        opFunc.func(this);
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                o.preorderMap(opFunc);
            }
        }
    }

    public void logStats() {
        for (String e : this.statsMap.keySet()) {
            this.LOG.info((Object)(e.toString() + ":" + this.statsMap.get(e).toString()));
        }
    }

    @Override
    public String getName() {
        return Operator.getOperatorName();
    }

    public static String getOperatorName() {
        return "OP";
    }

    public Map<String, ExprNodeDesc> getColumnExprMap() {
        return this.colExprMap;
    }

    public void setColumnExprMap(Map<String, ExprNodeDesc> colExprMap) {
        this.colExprMap = colExprMap;
    }

    private String getLevelString(int level) {
        if (level == 0) {
            return "\n";
        }
        StringBuilder s = new StringBuilder();
        s.append("\n");
        while (level > 0) {
            s.append("  ");
            --level;
        }
        return s.toString();
    }

    public String dump(int level) {
        return this.dump(level, new HashSet<Integer>());
    }

    public String dump(int level, HashSet<Integer> seenOpts) {
        if (seenOpts.contains(new Integer(this.id))) {
            return null;
        }
        seenOpts.add(new Integer(this.id));
        StringBuilder s = new StringBuilder();
        String ls = this.getLevelString(level);
        s.append(ls);
        s.append("<" + this.getName() + ">");
        s.append("Id =" + this.id);
        if (this.childOperators != null) {
            s.append(ls);
            s.append("  <Children>");
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                s.append(o.dump(level + 2, seenOpts));
            }
            s.append(ls);
            s.append("  <\\Children>");
        }
        if (this.parentOperators != null) {
            s.append(ls);
            s.append("  <Parent>");
            for (Operator<? extends OperatorDesc> o : this.parentOperators) {
                s.append("Id = " + o.id + " ");
                s.append(o.dump(level, seenOpts));
            }
            s.append("<\\Parent>");
        }
        s.append(ls);
        s.append("<\\" + this.getName() + ">");
        return s.toString();
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator[] evals, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[evals.length];
        for (int i = 0; i < evals.length; ++i) {
            result[i] = evals[i].initialize(rowInspector);
        }
        return result;
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator[] evals, int start, int length, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[length];
        for (int i = 0; i < length; ++i) {
            result[i] = evals[start + i].initialize(rowInspector);
        }
        return result;
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<String> outputColName, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] fieldObjectInspectors = Operator.initEvaluators(evals, rowInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColName, Arrays.asList(fieldObjectInspectors));
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void initOperatorId() {
        this.setOperatorId(this.getName() + "_" + this.id);
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    protected List<String> getAdditionalCounters() {
        return null;
    }

    public abstract OperatorType getType();

    public void setGroupKeyObject(Object keyObject) {
        this.groupKeyObject = keyObject;
    }

    public Object getGroupKeyObject() {
        return this.groupKeyObject;
    }

    public void augmentPlan() {
    }

    public ExecMapperContext getExecContext() {
        return this.execContext;
    }

    public void setExecContext(ExecMapperContext execContext) {
        this.execContext = execContext;
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends OperatorDesc> op = this.childOperators.get(i);
                op.setExecContext(execContext);
            }
        }
    }

    public void cleanUpInputFileChanged() throws HiveException {
        this.cleanUpInputFileChangedOp();
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends OperatorDesc> op = this.childOperators.get(i);
                op.cleanUpInputFileChanged();
            }
        }
    }

    public void cleanUpInputFileChangedOp() throws HiveException {
    }

    public void setInputContext(String inputPath, String tableName, String partitionName) {
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> child : this.childOperators) {
                if (child.getNumParent() != 1) continue;
                child.setInputContext(inputPath, tableName, partitionName);
            }
        }
    }

    public boolean supportSkewJoinOptimization() {
        return false;
    }

    public Operator<? extends OperatorDesc> clone() throws CloneNotSupportedException {
        List<Operator<OperatorDesc>> parents = this.getParentOperators();
        ArrayList<Operator<? extends OperatorDesc>> parentClones = new ArrayList<Operator<? extends OperatorDesc>>();
        if (parents != null) {
            for (Operator<OperatorDesc> parent : parents) {
                parentClones.add((Operator<? extends OperatorDesc>)parent.clone());
            }
        }
        OperatorDesc descClone = (OperatorDesc)this.conf.clone();
        Operator<OperatorDesc> ret = OperatorFactory.getAndMakeChild(descClone, this.getSchema(), this.getColumnExprMap(), parentClones);
        return ret;
    }

    public Operator<? extends OperatorDesc> cloneOp() throws CloneNotSupportedException {
        OperatorDesc descClone = (OperatorDesc)this.conf.clone();
        Operator<OperatorDesc> ret = OperatorFactory.getAndMakeChild(descClone, this.getSchema(), new Operator[0]);
        return ret;
    }

    public Operator<? extends OperatorDesc> cloneRecursiveChildren() throws CloneNotSupportedException {
        Operator<OperatorDesc> newOp = this.cloneOp();
        newOp.setParentOperators(this.parentOperators);
        if (this.getChildOperators() == null) {
            newOp.setChildOperators(null);
            return newOp;
        }
        ArrayList<Operator<? extends OperatorDesc>> newChildren = new ArrayList<Operator<? extends OperatorDesc>>();
        for (Operator<OperatorDesc> childOp : this.getChildOperators()) {
            ArrayList<Operator<? extends OperatorDesc>> parentList = new ArrayList<Operator<? extends OperatorDesc>>();
            for (Operator<OperatorDesc> parent : childOp.getParentOperators()) {
                if (parent.equals(this)) {
                    parentList.add(newOp);
                    continue;
                }
                parentList.add(parent);
            }
            Operator<OperatorDesc> clonedChildOp = childOp.cloneRecursiveChildren();
            clonedChildOp.setParentOperators(parentList);
        }
        newOp.setChildOperators(newChildren);
        return newOp;
    }

    public boolean columnNamesRowResolvedCanBeObtained() {
        return false;
    }

    public boolean isUseBucketizedHiveInputFormat() {
        return this.useBucketizedHiveInputFormat;
    }

    public void setUseBucketizedHiveInputFormat(boolean useBucketizedHiveInputFormat) {
        this.useBucketizedHiveInputFormat = useBucketizedHiveInputFormat;
    }

    public boolean supportAutomaticSortMergeJoin() {
        return false;
    }

    public boolean supportUnionRemoveOptimization() {
        return false;
    }

    public boolean opAllowedBeforeMapJoin() {
        return true;
    }

    public boolean opAllowedAfterMapJoin() {
        return true;
    }

    public boolean opAllowedConvertMapJoin() {
        return true;
    }

    public boolean opAllowedBeforeSortMergeJoin() {
        return true;
    }

    public boolean acceptLimitPushdown() {
        return false;
    }

    public String toString() {
        return this.getName() + "[" + this.getIdentifier() + "]";
    }

    public static String toString(Collection<Operator<? extends OperatorDesc>> top) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> visited = new HashSet<String>();
        for (Operator<? extends OperatorDesc> op : top) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            Operator.toString(builder, visited, op, 0);
        }
        return builder.toString();
    }

    static boolean toString(StringBuilder builder, Set<String> visited, Operator<?> op, int start) {
        String name = op.toString();
        boolean added = visited.add(name);
        if (start > 0) {
            builder.append("-");
            ++start;
        }
        builder.append(name);
        start += name.length();
        if (added) {
            if (op.getNumChild() > 0) {
                List<Operator<OperatorDesc>> children = op.getChildOperators();
                for (int i = 0; i < children.size(); ++i) {
                    if (i > 0) {
                        builder.append('\n');
                        for (int j = 0; j < start; ++j) {
                            builder.append(' ');
                        }
                    }
                    Operator.toString(builder, visited, children.get(i), start);
                }
            }
            return true;
        }
        return false;
    }

    public Statistics getStatistics() {
        if (this.conf != null) {
            return this.conf.getStatistics();
        }
        return null;
    }

    public OpTraits getOpTraits() {
        if (this.conf != null) {
            return this.conf.getOpTraits();
        }
        return null;
    }

    public void setOpTraits(OpTraits metaInfo) {
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)("Setting traits (" + metaInfo + ") on " + this));
        }
        if (this.conf != null) {
            this.conf.setOpTraits(metaInfo);
        } else {
            this.LOG.warn((Object)("Cannot set traits when there's no descriptor: " + this));
        }
    }

    public void setStatistics(Statistics stats) {
        if (this.isLogDebugEnabled) {
            this.LOG.debug((Object)("Setting stats (" + stats + ") on " + this));
        }
        if (this.conf != null) {
            this.conf.setStatistics(stats);
        } else {
            this.LOG.warn((Object)("Cannot set stats when there's no descriptor: " + this));
        }
    }

    public static Operator createDummy() {
        return new DummyOperator();
    }

    public Map<Integer, DummyStoreOperator> getTagToOperatorTree() {
        if (this.parentOperators == null || this.parentOperators.size() == 0) {
            return null;
        }
        Map<Integer, DummyStoreOperator> dummyOps = this.parentOperators.get(0).getTagToOperatorTree();
        return dummyOps;
    }

    private static class DummyOperator
    extends Operator {
        public DummyOperator() {
            super("dummy");
        }

        @Override
        public void processOp(Object row, int tag) {
        }

        @Override
        public OperatorType getType() {
            return null;
        }
    }

    public static interface OperatorFunc {
        public void func(Operator<? extends OperatorDesc> var1);
    }

    public static enum State {
        UNINIT,
        INIT,
        CLOSE;

    }
}

