/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssignFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSerde;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;

public class VectorizedRowBatchCtx {
    private static final Log LOG = LogFactory.getLog((String)VectorizedRowBatchCtx.class.getName());
    private StructObjectInspector rawRowOI;
    private StructObjectInspector rowOI;
    private Deserializer deserializer;
    private Map<String, Object> partitionValues;
    private Map<String, PrimitiveObjectInspector.PrimitiveCategory> partitionTypes;
    private Set<Integer> partitionCols;
    private List<Integer> colsToInclude;
    private Map<Integer, String> scratchColumnTypeMap = null;

    public VectorizedRowBatchCtx(StructObjectInspector rawRowOI, StructObjectInspector rowOI, Deserializer deserializer, Map<String, Object> partitionValues, Map<String, PrimitiveObjectInspector.PrimitiveCategory> partitionTypes) {
        this.rowOI = rowOI;
        this.rawRowOI = rawRowOI;
        this.deserializer = deserializer;
        this.partitionValues = partitionValues;
        this.partitionTypes = partitionTypes;
    }

    public VectorizedRowBatchCtx() {
    }

    public void init(Map<Integer, String> scratchColumnTypeMap, StructObjectInspector rowOI) {
        this.scratchColumnTypeMap = scratchColumnTypeMap;
        this.rowOI = rowOI;
        this.rawRowOI = rowOI;
    }

    public void init(Configuration hiveConf, FileSplit split) throws ClassNotFoundException, IOException, SerDeException, InstantiationException, IllegalAccessException, HiveException {
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapRedWork(hiveConf).getMapWork().getPathToPartitionInfo();
        PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, split.getPath(), IOPrepareCache.get().getPartitionDescMap());
        String partitionPath = split.getPath().getParent().toString();
        this.scratchColumnTypeMap = Utilities.getMapWorkAllScratchColumnVectorTypeMaps(hiveConf).get(partitionPath);
        Properties partProps = part.getPartSpec() == null || part.getPartSpec().isEmpty() ? part.getTableDesc().getProperties() : part.getProperties();
        Class serdeclass = hiveConf.getClassByName(part.getSerdeClassName());
        Deserializer partDeserializer = (Deserializer)serdeclass.newInstance();
        SerDeUtils.initializeSerDe(partDeserializer, hiveConf, part.getTableDesc().getProperties(), partProps);
        StructObjectInspector partRawRowObjectInspector = (StructObjectInspector)partDeserializer.getObjectInspector();
        this.deserializer = partDeserializer;
        String pcols = partProps.getProperty("partition_columns");
        String[] partKeys = null;
        if (pcols != null && pcols.length() > 0) {
            String pcolTypes;
            String[] partKeyTypes;
            LinkedHashMap<String, String> partSpec = part.getPartSpec();
            partKeys = pcols.trim().split("/");
            if (partKeys.length > (partKeyTypes = (pcolTypes = partProps.getProperty("partition_columns.types")).trim().split(":")).length) {
                throw new HiveException("Internal error : partKeys length, " + partKeys.length + " greater than partKeyTypes length, " + partKeyTypes.length);
            }
            ArrayList<String> partNames = new ArrayList<String>(partKeys.length);
            ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>(partKeys.length);
            this.partitionValues = new LinkedHashMap<String, Object>();
            this.partitionTypes = new LinkedHashMap<String, PrimitiveObjectInspector.PrimitiveCategory>();
            for (int i = 0; i < partKeys.length; ++i) {
                Object objectVal;
                String key = partKeys[i];
                partNames.add(key);
                ObjectInspector objectInspector = null;
                if (partSpec == null) {
                    objectVal = null;
                    objectInspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
                    this.partitionTypes.put(key, PrimitiveObjectInspector.PrimitiveCategory.STRING);
                } else {
                    objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(TypeInfoFactory.getPrimitiveTypeInfo(partKeyTypes[i]));
                    objectVal = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, objectInspector).convert(partSpec.get(key));
                    this.partitionTypes.put(key, TypeInfoFactory.getPrimitiveTypeInfo(partKeyTypes[i]).getPrimitiveCategory());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Partition column: name: " + key + ", value: " + objectVal + ", type: " + (Object)((Object)this.partitionTypes.get(key))));
                }
                this.partitionValues.put(key, objectVal);
                partObjectInspectors.add(objectInspector);
            }
            StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
            UnionStructObjectInspector rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(partRawRowObjectInspector, partObjectInspector));
            this.rowOI = rowObjectInspector;
            this.rawRowOI = partRawRowObjectInspector;
            this.partitionCols = new HashSet<Integer>();
            if (pcols != null && pcols.length() > 0) {
                for (int i = 0; i < partKeys.length; ++i) {
                    this.partitionCols.add(this.getColIndexBasedOnColName(partKeys[i]));
                }
            }
        } else {
            this.rowOI = partRawRowObjectInspector;
            this.rawRowOI = partRawRowObjectInspector;
        }
        this.colsToInclude = ColumnProjectionUtils.getReadColumnIDs(hiveConf);
    }

    public VectorizedRowBatch createVectorizedRowBatch() throws HiveException {
        List<? extends StructField> fieldRefs = this.rowOI.getAllStructFieldRefs();
        VectorizedRowBatch result = new VectorizedRowBatch(fieldRefs.size());
        block10: for (int j = 0; j < fieldRefs.size(); ++j) {
            if (this.colsToInclude != null && !this.colsToInclude.contains(j) && (this.partitionValues == null || !this.partitionValues.containsKey(fieldRefs.get(j).getFieldName()))) continue;
            ObjectInspector foi = fieldRefs.get(j).getFieldObjectInspector();
            switch (foi.getCategory()) {
                case PRIMITIVE: {
                    PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
                    switch (poi.getPrimitiveCategory()) {
                        case BOOLEAN: 
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case TIMESTAMP: 
                        case DATE: {
                            result.cols[j] = new LongColumnVector(1024);
                            continue block10;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            result.cols[j] = new DoubleColumnVector(1024);
                            continue block10;
                        }
                        case BINARY: 
                        case STRING: 
                        case CHAR: 
                        case VARCHAR: {
                            result.cols[j] = new BytesColumnVector(1024);
                            continue block10;
                        }
                        case DECIMAL: {
                            DecimalTypeInfo tInfo = (DecimalTypeInfo)poi.getTypeInfo();
                            result.cols[j] = new DecimalColumnVector(1024, tInfo.precision(), tInfo.scale());
                            continue block10;
                        }
                    }
                    throw new RuntimeException("Vectorizaton is not supported for datatype:" + (Object)((Object)poi.getPrimitiveCategory()));
                }
                case LIST: 
                case MAP: 
                case STRUCT: 
                case UNION: {
                    throw new HiveException("Vectorizaton is not supported for datatype:" + (Object)((Object)foi.getCategory()));
                }
                default: {
                    throw new HiveException("Unknown ObjectInspector category!");
                }
            }
        }
        result.numCols = fieldRefs.size();
        this.addScratchColumnsToBatch(result);
        result.reset();
        return result;
    }

    public void addRowToBatch(int rowIndex, Writable rowBlob, VectorizedRowBatch batch, DataOutputBuffer buffer) throws HiveException, SerDeException {
        Object row = this.deserializer.deserialize(rowBlob);
        VectorizedBatchUtil.addRowToBatch(row, this.rawRowOI, rowIndex, batch, buffer);
    }

    public void convertRowBatchBlobToVectorizedBatch(Object rowBlob, int rowsInBlob, VectorizedRowBatch batch) throws SerDeException {
        if (!(this.deserializer instanceof VectorizedSerde)) {
            throw new SerDeException("Not able to deserialize row batch. Serde does not implement VectorizedSerde");
        }
        ((VectorizedSerde)((Object)this.deserializer)).deserializeVector(rowBlob, rowsInBlob, batch);
    }

    private int getColIndexBasedOnColName(String colName) throws HiveException {
        List<? extends StructField> fieldRefs = this.rowOI.getAllStructFieldRefs();
        for (int i = 0; i < fieldRefs.size(); ++i) {
            if (!fieldRefs.get(i).getFieldName().equals(colName)) continue;
            return i;
        }
        throw new HiveException("Not able to find column name in row object inspector");
    }

    public void addPartitionColsToBatch(VectorizedRowBatch batch) throws HiveException {
        if (this.partitionValues != null) {
            for (String key : this.partitionValues.keySet()) {
                int colIndex = this.getColIndexBasedOnColName(key);
                Object value = this.partitionValues.get(key);
                PrimitiveObjectInspector.PrimitiveCategory pCategory = this.partitionTypes.get(key);
                switch (pCategory) {
                    case BOOLEAN: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill((Boolean)value == true ? 1L : 0L);
                        lcv.isNull[0] = false;
                        break;
                    }
                    case BYTE: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill(((Byte)value).byteValue());
                        lcv.isNull[0] = false;
                        break;
                    }
                    case SHORT: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill(((Short)value).shortValue());
                        lcv.isNull[0] = false;
                        break;
                    }
                    case INT: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill(((Integer)value).intValue());
                        lcv.isNull[0] = false;
                        break;
                    }
                    case LONG: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill((Long)value);
                        lcv.isNull[0] = false;
                        break;
                    }
                    case DATE: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill(DateWritable.dateToDays((Date)value));
                        lcv.isNull[0] = false;
                        break;
                    }
                    case TIMESTAMP: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            break;
                        }
                        lcv.fill(TimestampUtils.getTimeNanoSec((Timestamp)value));
                        lcv.isNull[0] = false;
                        break;
                    }
                    case FLOAT: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            break;
                        }
                        dcv.fill(((Float)value).floatValue());
                        dcv.isNull[0] = false;
                        break;
                    }
                    case DOUBLE: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            break;
                        }
                        dcv.fill((Double)value);
                        dcv.isNull[0] = false;
                        break;
                    }
                    case DECIMAL: {
                        DecimalColumnVector dv = (DecimalColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dv.noNulls = false;
                            dv.isNull[0] = true;
                            dv.isRepeating = true;
                            break;
                        }
                        HiveDecimal hd = (HiveDecimal)value;
                        dv.set(0, hd);
                        dv.isRepeating = true;
                        dv.isNull[0] = false;
                        break;
                    }
                    case BINARY: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        byte[] bytes = (byte[])value;
                        if (bytes == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            break;
                        }
                        bcv.fill(bytes);
                        bcv.isNull[0] = false;
                        break;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        String sVal = value.toString();
                        if (sVal == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            break;
                        }
                        bcv.fill(sVal.getBytes());
                        bcv.isNull[0] = false;
                        break;
                    }
                    default: {
                        throw new HiveException("Unable to recognize the partition type " + (Object)((Object)pCategory) + " for column " + key);
                    }
                }
            }
        }
    }

    public final boolean isPartitionCol(int colnum) {
        return this.partitionCols == null ? false : this.partitionCols.contains(colnum);
    }

    private void addScratchColumnsToBatch(VectorizedRowBatch vrb) throws HiveException {
        if (this.scratchColumnTypeMap != null && !this.scratchColumnTypeMap.isEmpty()) {
            int origNumCols = vrb.numCols;
            int newNumCols = vrb.cols.length + this.scratchColumnTypeMap.keySet().size();
            vrb.cols = Arrays.copyOf(vrb.cols, newNumCols);
            for (int i = origNumCols; i < newNumCols; ++i) {
                String typeName = this.scratchColumnTypeMap.get(i);
                if (typeName == null) {
                    throw new HiveException("No type found for column type entry " + i);
                }
                vrb.cols[i] = this.allocateColumnVector(typeName, 1024);
            }
            vrb.numCols = vrb.cols.length;
        }
    }

    private int[] getScalePrecisionFromDecimalType(String decimalType) {
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(decimalType);
        m.find();
        int precision = Integer.parseInt(m.group());
        m.find();
        int scale = Integer.parseInt(m.group());
        int[] precScale = new int[]{precision, scale};
        return precScale;
    }

    private ColumnVector allocateColumnVector(String type, int defaultSize) {
        if (type.equalsIgnoreCase("double")) {
            return new DoubleColumnVector(defaultSize);
        }
        if (VectorizationContext.isStringFamily(type)) {
            return new BytesColumnVector(defaultSize);
        }
        if (VectorizationContext.decimalTypePattern.matcher(type).matches()) {
            int[] precisionScale = this.getScalePrecisionFromDecimalType(type);
            return new DecimalColumnVector(defaultSize, precisionScale[0], precisionScale[1]);
        }
        if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("timestamp")) {
            return new LongColumnVector(defaultSize);
        }
        throw new Error("Cannot allocate vector column for " + type);
    }

    public VectorColumnAssign[] buildObjectAssigners(VectorizedRowBatch outputBatch) throws HiveException {
        List<? extends StructField> fieldRefs = this.rowOI.getAllStructFieldRefs();
        assert (outputBatch.numCols == fieldRefs.size());
        VectorColumnAssign[] assigners = new VectorColumnAssign[fieldRefs.size()];
        for (int i = 0; i < assigners.length; ++i) {
            StructField fieldRef = fieldRefs.get(i);
            ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
            assigners[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, fieldOI);
        }
        return assigners;
    }
}

