/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public final class VectorExpressionWriterFactory {
    public static VectorExpressionWriter genVectorExpressionWritable(ExprNodeDesc nodeDesc) throws HiveException {
        ObjectInspector objectInspector = nodeDesc.getWritableObjectInspector();
        if (null == objectInspector) {
            objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(nodeDesc.getTypeInfo());
        }
        if (null == objectInspector) {
            throw new HiveException(String.format("Failed to initialize VectorExpressionWriter for expr: %s", nodeDesc.getExprString()));
        }
        return VectorExpressionWriterFactory.genVectorExpressionWritable(objectInspector);
    }

    public static VectorExpressionWriter genVectorExpressionWritable(ObjectInspector fieldObjInspector) throws HiveException {
        switch (fieldObjInspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)fieldObjInspector).getPrimitiveCategory()) {
                    case FLOAT: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableFloat((SettableFloatObjectInspector)fieldObjInspector);
                    }
                    case DOUBLE: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableDouble((SettableDoubleObjectInspector)fieldObjInspector);
                    }
                    case BOOLEAN: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableBoolean((SettableBooleanObjectInspector)fieldObjInspector);
                    }
                    case BYTE: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableByte((SettableByteObjectInspector)fieldObjInspector);
                    }
                    case SHORT: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableShort((SettableShortObjectInspector)fieldObjInspector);
                    }
                    case INT: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableInt((SettableIntObjectInspector)fieldObjInspector);
                    }
                    case LONG: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableLong((SettableLongObjectInspector)fieldObjInspector);
                    }
                    case VOID: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableVoid((VoidObjectInspector)fieldObjInspector);
                    }
                    case BINARY: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableBinary((SettableBinaryObjectInspector)fieldObjInspector);
                    }
                    case STRING: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableString((SettableStringObjectInspector)fieldObjInspector);
                    }
                    case CHAR: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableChar((SettableHiveCharObjectInspector)fieldObjInspector);
                    }
                    case VARCHAR: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableVarchar((SettableHiveVarcharObjectInspector)fieldObjInspector);
                    }
                    case TIMESTAMP: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableTimestamp((SettableTimestampObjectInspector)fieldObjInspector);
                    }
                    case DATE: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableDate((SettableDateObjectInspector)fieldObjInspector);
                    }
                    case DECIMAL: {
                        return VectorExpressionWriterFactory.genVectorExpressionWritableDecimal((SettableHiveDecimalObjectInspector)fieldObjInspector);
                    }
                }
                throw new IllegalArgumentException("Unknown primitive type: " + (Object)((Object)((PrimitiveObjectInspector)fieldObjInspector).getPrimitiveCategory()));
            }
            case STRUCT: 
            case UNION: 
            case MAP: 
            case LIST: {
                throw new IllegalArgumentException("Unsupported complex type: " + (Object)((Object)fieldObjInspector.getCategory()));
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)fieldObjInspector.getCategory()));
    }

    public static VectorExpressionWriter[] genVectorStructExpressionWritables(StructObjectInspector oi) throws HiveException {
        VectorExpressionWriter[] writers = new VectorExpressionWriter[oi.getAllStructFieldRefs().size()];
        List<? extends StructField> fields = oi.getAllStructFieldRefs();
        int i = 0;
        for (StructField structField : fields) {
            writers[i++] = VectorExpressionWriterFactory.genVectorExpressionWritable(structField.getFieldObjectInspector());
        }
        return writers;
    }

    private static VectorExpressionWriter genVectorExpressionWritableDecimal(SettableHiveDecimalObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterDecimal(){
            private Object obj;

            public VectorExpressionWriter init(SettableHiveDecimalObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(HiveDecimalWritable value) throws HiveException {
                return ((SettableHiveDecimalObjectInspector)this.objectInspector).set(this.obj, value);
            }

            @Override
            public Object writeValue(HiveDecimal value) throws HiveException {
                return ((SettableHiveDecimalObjectInspector)this.objectInspector).set(this.obj, value);
            }

            @Override
            public Object setValue(Object field, HiveDecimalWritable value) {
                if (null == field) {
                    field = this.initValue(null);
                }
                return ((SettableHiveDecimalObjectInspector)this.objectInspector).set(field, value);
            }

            @Override
            public Object setValue(Object field, HiveDecimal value) {
                if (null == field) {
                    field = this.initValue(null);
                }
                return ((SettableHiveDecimalObjectInspector)this.objectInspector).set(field, value);
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableHiveDecimalObjectInspector)this.objectInspector).create(HiveDecimal.ZERO);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableDate(SettableDateObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Date dt;
            private Object obj;

            public VectorExpressionWriter init(SettableDateObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.dt = new Date(0L);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) {
                this.dt.setTime(DateWritable.daysToMillis((int)value));
                ((SettableDateObjectInspector)this.objectInspector).set(this.obj, this.dt);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) {
                if (null == field) {
                    field = this.initValue(null);
                }
                this.dt.setTime(DateWritable.daysToMillis((int)value));
                ((SettableDateObjectInspector)this.objectInspector).set(field, this.dt);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableDateObjectInspector)this.objectInspector).create(new Date(0L));
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableTimestamp(SettableTimestampObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;
            private Timestamp ts;

            public VectorExpressionWriter init(SettableTimestampObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.ts = new Timestamp(0L);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) {
                TimestampUtils.assignTimeInNanoSec(value, this.ts);
                ((SettableTimestampObjectInspector)this.objectInspector).set(this.obj, this.ts);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) {
                if (null == field) {
                    field = this.initValue(null);
                }
                TimestampUtils.assignTimeInNanoSec(value, this.ts);
                ((SettableTimestampObjectInspector)this.objectInspector).set(field, this.ts);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableTimestampObjectInspector)this.objectInspector).create(new Timestamp(0L));
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableChar(SettableHiveCharObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterBytes(){
            private Object obj;
            private Text text;

            public VectorExpressionWriter init(SettableHiveCharObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.text = new Text();
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(byte[] value, int start, int length) throws HiveException {
                this.text.set(value, start, length);
                ((SettableHiveCharObjectInspector)this.objectInspector).set(this.obj, this.text.toString());
                return this.obj;
            }

            @Override
            public Object setValue(Object field, byte[] value, int start, int length) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                this.text.set(value, start, length);
                ((SettableHiveCharObjectInspector)this.objectInspector).set(field, this.text.toString());
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableHiveCharObjectInspector)this.objectInspector).create(new HiveChar("", -1));
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableVarchar(SettableHiveVarcharObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterBytes(){
            private Object obj;
            private Text text;

            public VectorExpressionWriter init(SettableHiveVarcharObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.text = new Text();
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(byte[] value, int start, int length) throws HiveException {
                this.text.set(value, start, length);
                ((SettableHiveVarcharObjectInspector)this.objectInspector).set(this.obj, this.text.toString());
                return this.obj;
            }

            @Override
            public Object setValue(Object field, byte[] value, int start, int length) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                this.text.set(value, start, length);
                ((SettableHiveVarcharObjectInspector)this.objectInspector).set(field, this.text.toString());
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableHiveVarcharObjectInspector)this.objectInspector).create(new HiveVarchar("", -1));
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableString(SettableStringObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterBytes(){
            private Object obj;
            private Text text;

            public VectorExpressionWriter init(SettableStringObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.text = new Text();
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(byte[] value, int start, int length) throws HiveException {
                this.text.set(value, start, length);
                ((SettableStringObjectInspector)this.objectInspector).set(this.obj, this.text);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, byte[] value, int start, int length) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                this.text.set(value, start, length);
                ((SettableStringObjectInspector)this.objectInspector).set(field, this.text);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableStringObjectInspector)this.objectInspector).create("");
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableBinary(SettableBinaryObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterBytes(){
            private Object obj;
            private byte[] bytes;

            public VectorExpressionWriter init(SettableBinaryObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.bytes = ArrayUtils.EMPTY_BYTE_ARRAY;
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(byte[] value, int start, int length) throws HiveException {
                this.bytes = Arrays.copyOfRange(value, start, start + length);
                ((SettableBinaryObjectInspector)this.objectInspector).set(this.obj, this.bytes);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, byte[] value, int start, int length) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                this.bytes = Arrays.copyOfRange(value, start, start + length);
                ((SettableBinaryObjectInspector)this.objectInspector).set(field, this.bytes);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableBinaryObjectInspector)this.objectInspector).create(ArrayUtils.EMPTY_BYTE_ARRAY);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableLong(SettableLongObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(SettableLongObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                ((SettableLongObjectInspector)this.objectInspector).set(this.obj, value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableLongObjectInspector)this.objectInspector).set(field, value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableLongObjectInspector)this.objectInspector).create(0L);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableVoid(VoidObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(VoidObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((VoidObjectInspector)this.objectInspector).copyObject(null);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableInt(SettableIntObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(SettableIntObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                ((SettableIntObjectInspector)this.objectInspector).set(this.obj, (int)value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableIntObjectInspector)this.objectInspector).set(field, (int)value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableIntObjectInspector)this.objectInspector).create(0);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableShort(SettableShortObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(SettableShortObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                ((SettableShortObjectInspector)this.objectInspector).set(this.obj, (short)value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableShortObjectInspector)this.objectInspector).set(field, (short)value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableShortObjectInspector)this.objectInspector).create((short)0);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableByte(SettableByteObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(SettableByteObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                ((SettableByteObjectInspector)this.objectInspector).set(this.obj, (byte)value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableByteObjectInspector)this.objectInspector).set(field, (byte)value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableByteObjectInspector)this.objectInspector).create((byte)0);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableBoolean(SettableBooleanObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterLong(){
            private Object obj;

            public VectorExpressionWriter init(SettableBooleanObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(long value) throws HiveException {
                ((SettableBooleanObjectInspector)this.objectInspector).set(this.obj, value != 0L);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, long value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableBooleanObjectInspector)this.objectInspector).set(field, value != 0L);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableBooleanObjectInspector)this.objectInspector).create(false);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableDouble(SettableDoubleObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterDouble(){
            private Object obj;

            public VectorExpressionWriter init(SettableDoubleObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(double value) throws HiveException {
                ((SettableDoubleObjectInspector)this.objectInspector).set(this.obj, value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, double value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableDoubleObjectInspector)this.objectInspector).set(field, value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableDoubleObjectInspector)this.objectInspector).create(0.0);
            }
        }.init(fieldObjInspector);
    }

    private static VectorExpressionWriter genVectorExpressionWritableFloat(SettableFloatObjectInspector fieldObjInspector) throws HiveException {
        return new VectorExpressionWriterDouble(){
            private Object obj;

            public VectorExpressionWriter init(SettableFloatObjectInspector objInspector) throws HiveException {
                super.init(objInspector);
                this.obj = this.initValue(null);
                return this;
            }

            @Override
            public Object writeValue(double value) throws HiveException {
                ((SettableFloatObjectInspector)this.objectInspector).set(this.obj, (float)value);
                return this.obj;
            }

            @Override
            public Object setValue(Object field, double value) throws HiveException {
                if (null == field) {
                    field = this.initValue(null);
                }
                ((SettableFloatObjectInspector)this.objectInspector).set(field, (float)value);
                return field;
            }

            @Override
            public Object initValue(Object ignored) {
                return ((SettableFloatObjectInspector)this.objectInspector).create(0.0f);
            }
        }.init(fieldObjInspector);
    }

    public static VectorExpressionWriter[] getExpressionWriters(List<ExprNodeDesc> nodesDesc) throws HiveException {
        VectorExpressionWriter[] writers = new VectorExpressionWriter[nodesDesc.size()];
        for (int i = 0; i < writers.length; ++i) {
            ExprNodeDesc nodeDesc = nodesDesc.get(i);
            writers[i] = VectorExpressionWriterFactory.genVectorExpressionWritable(nodeDesc);
        }
        return writers;
    }

    public static void processVectorExpressions(List<ExprNodeDesc> nodesDesc, List<String> columnNames, SingleOIDClosure closure) throws HiveException {
        VectorExpressionWriter[] writers = VectorExpressionWriterFactory.getExpressionWriters(nodesDesc);
        ArrayList<ObjectInspector> oids = new ArrayList<ObjectInspector>(writers.length);
        for (int i = 0; i < writers.length; ++i) {
            oids.add(writers[i].getObjectInspector());
        }
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, oids);
        closure.assign(writers, objectInspector);
    }

    public static void processVectorExpressions(List<ExprNodeDesc> nodesDesc, ListOIDClosure closure) throws HiveException {
        VectorExpressionWriter[] writers = VectorExpressionWriterFactory.getExpressionWriters(nodesDesc);
        ArrayList<ObjectInspector> oids = new ArrayList<ObjectInspector>(writers.length);
        for (int i = 0; i < writers.length; ++i) {
            oids.add(writers[i].getObjectInspector());
        }
        closure.assign(writers, oids);
    }

    public static void processVectorInspector(StructObjectInspector structObjInspector, SingleOIDClosure closure) throws HiveException {
        List<? extends StructField> fields = structObjInspector.getAllStructFieldRefs();
        VectorExpressionWriter[] writers = new VectorExpressionWriter[fields.size()];
        ArrayList<ObjectInspector> oids = new ArrayList<ObjectInspector>(writers.length);
        ArrayList<String> columnNames = new ArrayList<String>();
        int i = 0;
        for (StructField structField : fields) {
            ObjectInspector fieldObjInsp = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()));
            writers[i] = VectorExpressionWriterFactory.genVectorExpressionWritable(fieldObjInsp);
            columnNames.add(structField.getFieldName());
            oids.add(writers[i].getObjectInspector());
            ++i;
        }
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, oids);
        closure.assign(writers, objectInspector);
    }

    public static VectorExpressionWriter[] getExpressionWriters(StructObjectInspector objInspector) throws HiveException {
        if (objInspector.isSettable()) {
            return VectorExpressionWriterFactory.getSettableExpressionWriters((SettableStructObjectInspector)objInspector);
        }
        List<? extends StructField> allFieldRefs = objInspector.getAllStructFieldRefs();
        VectorExpressionWriter[] expressionWriters = new VectorExpressionWriter[allFieldRefs.size()];
        for (int i = 0; i < expressionWriters.length; ++i) {
            expressionWriters[i] = VectorExpressionWriterFactory.genVectorExpressionWritable(allFieldRefs.get(i).getFieldObjectInspector());
        }
        return expressionWriters;
    }

    public static VectorExpressionWriter[] getSettableExpressionWriters(SettableStructObjectInspector objInspector) throws HiveException {
        List<? extends StructField> fieldsRef = objInspector.getAllStructFieldRefs();
        VectorExpressionWriter[] writers = new VectorExpressionWriter[fieldsRef.size()];
        for (int i = 0; i < writers.length; ++i) {
            StructField fieldRef = fieldsRef.get(i);
            VectorExpressionWriter baseWriter = VectorExpressionWriterFactory.genVectorExpressionWritable(fieldRef.getFieldObjectInspector());
            writers[i] = VectorExpressionWriterFactory.genVectorExpressionWritable(objInspector, fieldRef, baseWriter);
        }
        return writers;
    }

    private static VectorExpressionWriter genVectorExpressionWritable(SettableStructObjectInspector objInspector, StructField fieldRef, VectorExpressionWriter baseWriter) throws HiveException {
        return new VectorExpressionWriterSetter().init(objInspector, fieldRef, baseWriter);
    }

    private static class VectorExpressionWriterSetter
    extends VectorExpressionWriterBase {
        private SettableStructObjectInspector settableObjInspector;
        private StructField fieldRef;
        private VectorExpressionWriter baseWriter;

        private VectorExpressionWriterSetter() {
        }

        public VectorExpressionWriterSetter init(SettableStructObjectInspector objInspector, StructField fieldRef, VectorExpressionWriter baseWriter) {
            this.fieldRef = fieldRef;
            this.settableObjInspector = objInspector;
            this.objectInspector = fieldRef.getFieldObjectInspector();
            this.baseWriter = baseWriter;
            return this;
        }

        @Override
        public Object writeValue(ColumnVector column, int row) throws HiveException {
            return this.baseWriter.writeValue(column, row);
        }

        @Override
        public Object setValue(Object row, ColumnVector column, int columnRow) throws HiveException {
            Object fieldValue = this.settableObjInspector.getStructFieldData(row, this.fieldRef);
            fieldValue = this.baseWriter.setValue(fieldValue, column, columnRow);
            return this.settableObjInspector.setStructFieldData(row, this.fieldRef, fieldValue);
        }

        @Override
        public Object initValue(Object struct) throws HiveException {
            Object initValue = this.baseWriter.initValue(null);
            this.settableObjInspector.setStructFieldData(struct, this.fieldRef, initValue);
            return struct;
        }
    }

    public static interface ListOIDClosure {
        public void assign(VectorExpressionWriter[] var1, List<ObjectInspector> var2);
    }

    public static interface SingleOIDClosure {
        public void assign(VectorExpressionWriter[] var1, ObjectInspector var2);
    }

    private static abstract class VectorExpressionWriterDecimal
    extends VectorExpressionWriterBase {
        private VectorExpressionWriterDecimal() {
        }

        @Override
        public Object writeValue(ColumnVector column, int row) throws HiveException {
            DecimalColumnVector dcv = (DecimalColumnVector)column;
            if (dcv.noNulls && !dcv.isRepeating) {
                return this.writeValue(dcv.vector[row]);
            }
            if (dcv.noNulls && dcv.isRepeating) {
                return this.writeValue(dcv.vector[0]);
            }
            if (!(dcv.noNulls || dcv.isRepeating || dcv.isNull[row])) {
                return this.writeValue(dcv.vector[row]);
            }
            if (!dcv.noNulls && dcv.isRepeating && !dcv.isNull[0]) {
                return this.writeValue(dcv.vector[0]);
            }
            if (!dcv.noNulls && dcv.isRepeating && dcv.isNull[0]) {
                return null;
            }
            if (!dcv.noNulls && !dcv.isRepeating && dcv.isNull[row]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, dcv.noNulls, dcv.isRepeating, dcv.isNull[row], dcv.isNull[0]));
        }

        @Override
        public Object setValue(Object field, ColumnVector column, int row) throws HiveException {
            DecimalColumnVector dcv = (DecimalColumnVector)column;
            if (dcv.noNulls && !dcv.isRepeating) {
                return this.setValue(field, dcv.vector[row]);
            }
            if (dcv.noNulls && dcv.isRepeating) {
                return this.setValue(field, dcv.vector[0]);
            }
            if (!(dcv.noNulls || dcv.isRepeating || dcv.isNull[row])) {
                return this.setValue(field, dcv.vector[row]);
            }
            if (!dcv.noNulls && !dcv.isRepeating && dcv.isNull[row]) {
                return null;
            }
            if (!dcv.noNulls && dcv.isRepeating && !dcv.isNull[0]) {
                return this.setValue(field, dcv.vector[0]);
            }
            if (!dcv.noNulls && dcv.isRepeating && dcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, dcv.noNulls, dcv.isRepeating, dcv.isNull[row], dcv.isNull[0]));
        }
    }

    private static abstract class VectorExpressionWriterBytes
    extends VectorExpressionWriterBase {
        private VectorExpressionWriterBytes() {
        }

        @Override
        public Object writeValue(ColumnVector column, int row) throws HiveException {
            BytesColumnVector bcv = (BytesColumnVector)column;
            if (bcv.noNulls && !bcv.isRepeating) {
                return this.writeValue(bcv.vector[row], bcv.start[row], bcv.length[row]);
            }
            if (bcv.noNulls && bcv.isRepeating) {
                return this.writeValue(bcv.vector[0], bcv.start[0], bcv.length[0]);
            }
            if (!(bcv.noNulls || bcv.isRepeating || bcv.isNull[row])) {
                return this.writeValue(bcv.vector[row], bcv.start[row], bcv.length[row]);
            }
            if (!bcv.noNulls && !bcv.isRepeating && bcv.isNull[row]) {
                return null;
            }
            if (!bcv.noNulls && bcv.isRepeating && !bcv.isNull[0]) {
                return this.writeValue(bcv.vector[0], bcv.start[0], bcv.length[0]);
            }
            if (!bcv.noNulls && bcv.isRepeating && bcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, bcv.noNulls, bcv.isRepeating, bcv.isNull[row], bcv.isNull[0]));
        }

        @Override
        public Object setValue(Object field, ColumnVector column, int row) throws HiveException {
            BytesColumnVector bcv = (BytesColumnVector)column;
            if (bcv.noNulls && !bcv.isRepeating) {
                return this.setValue(field, bcv.vector[row], bcv.start[row], bcv.length[row]);
            }
            if (bcv.noNulls && bcv.isRepeating) {
                return this.setValue(field, bcv.vector[0], bcv.start[0], bcv.length[0]);
            }
            if (!(bcv.noNulls || bcv.isRepeating || bcv.isNull[row])) {
                return this.setValue(field, bcv.vector[row], bcv.start[row], bcv.length[row]);
            }
            if (!bcv.noNulls && !bcv.isRepeating && bcv.isNull[row]) {
                return null;
            }
            if (!bcv.noNulls && bcv.isRepeating && !bcv.isNull[0]) {
                return this.setValue(field, bcv.vector[0], bcv.start[0], bcv.length[0]);
            }
            if (!bcv.noNulls && bcv.isRepeating && bcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, bcv.noNulls, bcv.isRepeating, bcv.isNull[row], bcv.isNull[0]));
        }
    }

    private static abstract class VectorExpressionWriterDouble
    extends VectorExpressionWriterBase {
        private VectorExpressionWriterDouble() {
        }

        @Override
        public Object writeValue(ColumnVector column, int row) throws HiveException {
            DoubleColumnVector dcv = (DoubleColumnVector)column;
            if (dcv.noNulls && !dcv.isRepeating) {
                return this.writeValue(dcv.vector[row]);
            }
            if (dcv.noNulls && dcv.isRepeating) {
                return this.writeValue(dcv.vector[0]);
            }
            if (!(dcv.noNulls || dcv.isRepeating || dcv.isNull[row])) {
                return this.writeValue(dcv.vector[row]);
            }
            if (!dcv.noNulls && !dcv.isRepeating && dcv.isNull[row]) {
                return null;
            }
            if (!dcv.noNulls && dcv.isRepeating && !dcv.isNull[0]) {
                return this.writeValue(dcv.vector[0]);
            }
            if (!dcv.noNulls && dcv.isRepeating && dcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, dcv.noNulls, dcv.isRepeating, dcv.isNull[row], dcv.isNull[0]));
        }

        @Override
        public Object setValue(Object field, ColumnVector column, int row) throws HiveException {
            DoubleColumnVector dcv = (DoubleColumnVector)column;
            if (dcv.noNulls && !dcv.isRepeating) {
                return this.setValue(field, dcv.vector[row]);
            }
            if (dcv.noNulls && dcv.isRepeating) {
                return this.setValue(field, dcv.vector[0]);
            }
            if (!(dcv.noNulls || dcv.isRepeating || dcv.isNull[row])) {
                return this.setValue(field, dcv.vector[row]);
            }
            if (!dcv.noNulls && !dcv.isRepeating && dcv.isNull[row]) {
                return null;
            }
            if (!dcv.noNulls && dcv.isRepeating && !dcv.isNull[0]) {
                return this.setValue(field, dcv.vector[0]);
            }
            if (!dcv.noNulls && dcv.isRepeating && dcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, dcv.noNulls, dcv.isRepeating, dcv.isNull[row], dcv.isNull[0]));
        }
    }

    private static abstract class VectorExpressionWriterLong
    extends VectorExpressionWriterBase {
        private VectorExpressionWriterLong() {
        }

        @Override
        public Object writeValue(ColumnVector column, int row) throws HiveException {
            LongColumnVector lcv = (LongColumnVector)column;
            if (lcv.noNulls && !lcv.isRepeating) {
                return this.writeValue(lcv.vector[row]);
            }
            if (lcv.noNulls && lcv.isRepeating) {
                return this.writeValue(lcv.vector[0]);
            }
            if (!(lcv.noNulls || lcv.isRepeating || lcv.isNull[row])) {
                return this.writeValue(lcv.vector[row]);
            }
            if (!lcv.noNulls && !lcv.isRepeating && lcv.isNull[row]) {
                return null;
            }
            if (!lcv.noNulls && lcv.isRepeating && !lcv.isNull[0]) {
                return this.writeValue(lcv.vector[0]);
            }
            if (!lcv.noNulls && lcv.isRepeating && lcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, lcv.noNulls, lcv.isRepeating, lcv.isNull[row], lcv.isNull[0]));
        }

        @Override
        public Object setValue(Object field, ColumnVector column, int row) throws HiveException {
            LongColumnVector lcv = (LongColumnVector)column;
            if (lcv.noNulls && !lcv.isRepeating) {
                return this.setValue(field, lcv.vector[row]);
            }
            if (lcv.noNulls && lcv.isRepeating) {
                return this.setValue(field, lcv.vector[0]);
            }
            if (!(lcv.noNulls || lcv.isRepeating || lcv.isNull[row])) {
                return this.setValue(field, lcv.vector[row]);
            }
            if (!lcv.noNulls && !lcv.isRepeating && lcv.isNull[row]) {
                return null;
            }
            if (!lcv.noNulls && lcv.isRepeating && !lcv.isNull[0]) {
                return this.setValue(field, lcv.vector[0]);
            }
            if (!lcv.noNulls && lcv.isRepeating && lcv.isNull[0]) {
                return null;
            }
            throw new HiveException(String.format("Incorrect null/repeating: row:%d noNulls:%b isRepeating:%b isNull[row]:%b isNull[0]:%b", row, lcv.noNulls, lcv.isRepeating, lcv.isNull[row], lcv.isNull[0]));
        }
    }

    private static abstract class VectorExpressionWriterBase
    implements VectorExpressionWriter {
        protected ObjectInspector objectInspector;

        private VectorExpressionWriterBase() {
        }

        @Override
        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public VectorExpressionWriter init(ObjectInspector objectInspector) throws HiveException {
            this.objectInspector = objectInspector;
            return this;
        }

        @Override
        public Object writeValue(long value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        public Object setValue(Object field, long value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public Object writeValue(double value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        public Object setValue(Object field, double value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public Object writeValue(byte[] value, int start, int length) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        public Object setValue(Object field, byte[] value, int start, int length) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public Object writeValue(HiveDecimal value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public Object writeValue(HiveDecimalWritable value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        public Object setValue(Object field, HiveDecimalWritable value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        public Object setValue(Object field, HiveDecimal value) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }
    }
}

