/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.Collections;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveJoin
extends Join
implements HiveRelNode {
    public static final RelFactories.JoinFactory HIVE_JOIN_FACTORY = new HiveJoinFactoryImpl();
    private final boolean leftSemiJoin;
    private final JoinAlgorithm joinAlgorithm;
    private final MapJoinStreamingRelation mapJoinStreamingSide = MapJoinStreamingRelation.NONE;

    public static HiveJoin getJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean leftSemiJoin) {
        try {
            Set<String> variablesStopped = Collections.emptySet();
            return new HiveJoin(cluster, null, left, right, condition, joinType, variablesStopped, JoinAlgorithm.NONE, null, leftSemiJoin);
        }
        catch (InvalidRelException e) {
            throw new RuntimeException(e);
        }
    }

    protected HiveJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, JoinAlgorithm joinAlgo, MapJoinStreamingRelation streamingSideForMapJoin, boolean leftSemiJoin) throws InvalidRelException {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), left, right, condition, joinType, variablesStopped);
        this.joinAlgorithm = joinAlgo;
        this.leftSemiJoin = leftSemiJoin;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public final HiveJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            Set<String> variablesStopped = Collections.emptySet();
            return new HiveJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType, variablesStopped, JoinAlgorithm.NONE, null, this.leftSemiJoin);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public JoinAlgorithm getJoinAlgorithm() {
        return this.joinAlgorithm;
    }

    public boolean isLeftSemiJoin() {
        return this.leftSemiJoin;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double leftRCount = RelMetadataQuery.getRowCount((RelNode)this.getLeft());
        double rightRCount = RelMetadataQuery.getRowCount((RelNode)this.getRight());
        return HiveCost.FACTORY.makeCost(leftRCount + rightRCount, 0.0, 0.0);
    }

    public RelDataType deriveRowType() {
        if (this.leftSemiJoin) {
            return HiveJoin.deriveJoinRowType((RelDataType)this.left.getRowType(), null, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, Collections.emptyList());
        }
        return super.deriveRowType();
    }

    private static class HiveJoinFactoryImpl
    implements RelFactories.JoinFactory {
        private HiveJoinFactoryImpl() {
        }

        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return HiveJoin.getJoin(left.getCluster(), left, right, condition, joinType, false);
        }
    }

    public static enum MapJoinStreamingRelation {
        NONE,
        LEFT_RELATION,
        RIGHT_RELATION;

    }

    public static enum JoinAlgorithm {
        NONE,
        COMMON_JOIN,
        MAP_JOIN,
        BUCKET_JOIN,
        SMB_JOIN;

    }
}

