/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.master.handler.DeleteTableHandler;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;

@InterfaceAudience.Private
public class TruncateTableHandler
extends DeleteTableHandler {
    private static final Log LOG = LogFactory.getLog(TruncateTableHandler.class);
    private final boolean preserveSplits;

    public TruncateTableHandler(TableName tableName, Server server, MasterServices masterServices, boolean preserveSplits) {
        super(tableName, server, masterServices);
        this.preserveSplits = preserveSplits;
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException, CoordinatedStateException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTruncateTableHandler(this.tableName);
        }
        this.waitRegionInTransition(regions);
        this.removeTableData(regions);
        this.recreateTable(regions);
        if (cpHost != null) {
            cpHost.postTruncateTableHandler(this.tableName);
        }
    }

    private void recreateTable(List<HRegionInfo> regions) throws IOException {
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempdir = mfs.getTempDir();
        FileSystem fs = mfs.getFileSystem();
        AssignmentManager assignmentManager = this.masterServices.getAssignmentManager();
        CreateTableHandler.checkAndSetEnablingTable(assignmentManager, this.tableName, false);
        try {
            HRegionInfo[] newRegions;
            Path tempTableDir = FSUtils.getTableDir(tempdir, this.tableName);
            new FSTableDescriptors(this.server.getConfiguration()).createTableDescriptorForTableDirectory(tempTableDir, this.hTableDescriptor, false);
            Path tableDir = FSUtils.getTableDir(mfs.getRootDir(), this.tableName);
            if (this.preserveSplits) {
                newRegions = TruncateTableHandler.recreateRegionInfo(regions);
                LOG.info((Object)("Truncate will preserve " + newRegions.length + " regions"));
            } else {
                newRegions = new HRegionInfo[]{new HRegionInfo(this.tableName, null, null)};
                LOG.info((Object)"Truncate will not preserve the regions");
            }
            List<HRegionInfo> regionInfos = ModifyRegionUtils.createRegions(this.masterServices.getConfiguration(), tempdir, this.hTableDescriptor, newRegions, null);
            if (!fs.rename(tempTableDir, tableDir)) {
                throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
            }
            MetaTableAccessor.addRegionsToMeta((Connection)this.masterServices.getConnection(), regionInfos, (int)this.hTableDescriptor.getRegionReplication());
            ModifyRegionUtils.assignRegions(assignmentManager, regionInfos);
            try {
                assignmentManager.getTableStateManager().setTableState(this.tableName, ZooKeeperProtos.Table.State.ENABLED);
            }
            catch (CoordinatedStateException e) {
                throw new IOException("Unable to ensure that " + this.tableName + " will be" + " enabled because of a ZooKeeper issue", e);
            }
        }
        catch (IOException e) {
            CreateTableHandler.removeEnablingTable(assignmentManager, this.tableName);
            throw e;
        }
    }

    private static HRegionInfo[] recreateRegionInfo(List<HRegionInfo> regions) {
        HRegionInfo[] newRegions = new HRegionInfo[regions.size()];
        int index = 0;
        for (HRegionInfo hri : regions) {
            newRegions[index++] = new HRegionInfo(hri.getTable(), hri.getStartKey(), hri.getEndKey());
        }
        return newRegions;
    }
}

