/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforcedelete;

import com.sforce.soap.partner.Error;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforce.SalesforceStep;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDeleteData;
import org.pentaho.di.trans.steps.salesforcedelete.SalesforceDeleteMeta;

public class SalesforceDelete
extends SalesforceStep {
    private static Class<?> PKG = SalesforceDeleteMeta.class;
    private SalesforceDeleteMeta meta;
    private SalesforceDeleteData data;

    public SalesforceDelete(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (this.data.iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.deleteId = new String[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            String realFieldName = this.environmentSubstitute(this.meta.getDeleteField());
            if (Utils.isEmpty((CharSequence)realFieldName)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.DeleteKeyFieldMissing", (String[])new String[0]));
            }
            this.data.indexOfKeyField = this.getInputRowMeta().indexOfValue(realFieldName);
            if (this.data.indexOfKeyField < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.CanNotFindFDeleteKeyField", (String[])new String[]{realFieldName}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SalesforceDelete.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private void writeToSalesForce(Object[] rowData) throws KettleException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.WriteToSalesforce", (Object[])new Object[]{this.data.iBufferPos, this.meta.getBatchSizeInt()}));
            }
            if (this.data.iBufferPos < this.meta.getBatchSizeInt()) {
                this.data.deleteId[this.data.iBufferPos] = this.getInputRowMeta().getString(rowData, this.data.indexOfKeyField);
                this.data.outputBuffer[this.data.iBufferPos] = rowData;
                ++this.data.iBufferPos;
            }
            if (this.data.iBufferPos >= this.meta.getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.CallingFlush", (String[])new String[0]));
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.WriteToSalesforce", (String[])new String[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws KettleException {
        try {
            if (this.data.deleteId.length > this.data.iBufferPos) {
                String[] smallBuffer = new String[this.data.iBufferPos];
                System.arraycopy(this.data.deleteId, 0, smallBuffer, 0, this.data.iBufferPos);
                this.data.deleteId = smallBuffer;
            }
            this.data.deleteResult = this.data.connection.delete(this.data.deleteId);
            int nr = this.data.deleteResult.length;
            for (int j = 0; j < nr; ++j) {
                if (this.data.deleteResult[j].isSuccess()) {
                    this.putRow(this.data.outputRowMeta, this.data.outputBuffer[j]);
                    this.incrementLinesOutput();
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.log.LineRow", (String[])new String[]{String.valueOf(this.getLinesInput())}));
                    continue;
                }
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Found.Error", (String[])new String[0]));
                    }
                    Error err = this.data.deleteResult[j].getErrors()[0];
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()}));
                }
                String errorMessage = "";
                int nrErrors = this.data.deleteResult[j].getErrors().length;
                for (int i = 0; i < nrErrors; ++i) {
                    Error err = this.data.deleteResult[j].getErrors()[i];
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceDelete.PassingRowToErrorStep", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), this.data.outputBuffer[j], 1L, errorMessage, null, "SalesforceDelete001");
            }
            this.data.deleteId = new String[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceDelete.FailedToDeleted", (String[])new String[]{e.getMessage()}));
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error step");
            }
            for (int i = 0; i < this.data.iBufferPos; ++i) {
                this.putError(this.data.inputRowMeta, this.data.outputBuffer[i], 1L, e.getMessage(), null, "SalesforceDelete002");
            }
        }
        finally {
            if (this.data.deleteResult != null) {
                this.data.deleteResult = null;
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceDeleteMeta)smi;
        this.data = (SalesforceDeleteData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.connection.setTimeOut(Const.toInt((String)this.environmentSubstitute(this.meta.getTimeout()), (int)0));
                this.data.connection.setUsingCompression(this.meta.isCompression());
                this.data.connection.setRollbackAllChangesOnError(this.meta.isRollbackAllChangesOnError());
                this.data.connection.connect();
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.outputBuffer != null) {
            this.data.outputBuffer = null;
        }
        if (this.data.deleteId != null) {
            this.data.deleteId = null;
        }
        super.dispose(smi, sdi);
    }
}

