/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceutils;

import java.util.regex.Pattern;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class SalesforceUtils {
    private static Class<?> PKG = SalesforceUtils.class;
    private static final String EXTID_SEPARATOR = "/";
    private static final String CUSTOM_OBJECT_RELATIONSHIP_FIELD_SUFFIX = "_r";
    private static final String CUSTOM_OBJECT_SUFFIX = "_c";
    private static final Pattern FIELD_NAME_WITH_EXTID_PATTERN = Pattern.compile("^\\w+\\:\\w+\\/\\w+$");

    private SalesforceUtils() {
    }

    public static String getFieldToNullName(LogChannelInterface log, String field, boolean isUseExtId) {
        String fieldToNullName = field;
        if (isUseExtId) {
            if (!FIELD_NAME_WITH_EXTID_PATTERN.matcher(field).matches()) {
                if (log.isDebug()) {
                    log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUtils.Warn.IncorrectExternalKeySyntax", (String[])new String[]{field, fieldToNullName}));
                }
                return fieldToNullName;
            }
            String lookupField = field.substring(field.indexOf(EXTID_SEPARATOR) + 1);
            if (lookupField.endsWith(CUSTOM_OBJECT_RELATIONSHIP_FIELD_SUFFIX)) {
                fieldToNullName = lookupField.substring(0, lookupField.length() - CUSTOM_OBJECT_RELATIONSHIP_FIELD_SUFFIX.length()) + CUSTOM_OBJECT_SUFFIX;
                if (log.isDebug()) {
                    log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUtils.Debug.NullFieldName", (String[])new String[]{fieldToNullName}));
                }
                return fieldToNullName;
            }
            fieldToNullName = lookupField + "Id";
        }
        if (log.isDebug()) {
            log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUtils.Debug.NullFieldName", (String[])new String[]{fieldToNullName}));
        }
        return fieldToNullName;
    }
}

