/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.cf;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.bsf.util.cf.CodeFormatter;

public class CFDriver {
    static /* synthetic */ Class class$org$apache$bsf$util$cf$CFDriver;

    public static void main(String[] argv) {
        if (argv.length % 2 == 0) {
            String inFile = null;
            String outFile = null;
            String maxLine = null;
            String indStep = null;
            String delim = null;
            String sDelim = null;
            InputStreamReader in = null;
            OutputStreamWriter out = null;
            CodeFormatter cf = new CodeFormatter();
            for (int i = 0; i < argv.length; i += 2) {
                if (argv[i].startsWith("-i")) {
                    inFile = argv[i + 1];
                    continue;
                }
                if (argv[i].startsWith("-o")) {
                    outFile = argv[i + 1];
                    continue;
                }
                if (argv[i].startsWith("-m")) {
                    maxLine = argv[i + 1];
                    continue;
                }
                if (argv[i].startsWith("-st")) {
                    indStep = argv[i + 1];
                    continue;
                }
                if (argv[i].startsWith("-d")) {
                    delim = argv[i + 1];
                    continue;
                }
                if (!argv[i].startsWith("-sd")) continue;
                sDelim = argv[i + 1];
            }
            if (inFile != null) {
                try {
                    in = new FileReader(inFile);
                }
                catch (FileNotFoundException e) {
                    CFDriver.printError("Cannot open input file: " + inFile);
                    return;
                }
            } else {
                in = new InputStreamReader(System.in);
            }
            if (outFile != null) {
                try {
                    out = new FileWriter(outFile);
                }
                catch (IOException e) {
                    CFDriver.printError("Cannot open output file: " + outFile);
                    return;
                }
            } else {
                out = new OutputStreamWriter(System.out);
            }
            if (maxLine != null) {
                try {
                    cf.setMaxLineLength(Integer.parseInt(maxLine));
                }
                catch (NumberFormatException nfe) {
                    CFDriver.printError("Not a valid integer: " + maxLine);
                    return;
                }
            }
            if (indStep != null) {
                try {
                    cf.setIndentationStep(Integer.parseInt(indStep));
                }
                catch (NumberFormatException nfe) {
                    CFDriver.printError("Not a valid integer: " + indStep);
                    return;
                }
            }
            if (delim != null) {
                cf.setDelimiters(delim);
            }
            if (sDelim != null) {
                cf.setStickyDelimiters(sDelim);
            }
            cf.formatCode(in, out);
        } else {
            CFDriver.printHelp();
        }
    }

    private static void printError(String errMsg) {
        System.err.println("ERROR: " + errMsg);
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("  java " + (class$org$apache$bsf$util$cf$CFDriver == null ? (class$org$apache$bsf$util$cf$CFDriver = CFDriver.class$("org.apache.bsf.util.cf.CFDriver")) : class$org$apache$bsf$util$cf$CFDriver).getName() + " [args]");
        System.out.println();
        System.out.println("    args:");
        System.out.println();
        System.out.println("      [-in      fileName]   default: <STDIN>");
        System.out.println("      [-out     fileName]   default: <STDOUT>");
        System.out.println("      [-maxLine   length]   default: 74");
        System.out.println("      [-step        size]   default: 2");
        System.out.println("      [-delim      group]   default: (+");
        System.out.println("      [-sdelim     group]   default: ,");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

