/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository.IClientRepositoryPathsStrategy;
import org.pentaho.platform.repository2.DefaultClientRepositoryPathsStrategy;

public class ClientRepositoryPaths {
    private static final Log logger = LogFactory.getLog(ClientRepositoryPaths.class);
    public static final String DEFAULT = "DEFAULT";
    public static final String SYSTEM_PROPERTY = "pentaho.repository.client.pathsStrategy";
    private static String strategyName = System.getProperty("pentaho.repository.client.pathsStrategy");
    private static IClientRepositoryPathsStrategy strategy;

    private ClientRepositoryPaths() {
    }

    public static String getPublicFolderName() {
        return strategy.getPublicFolderName();
    }

    public static String getHomeFolderName() {
        return strategy.getHomeFolderName();
    }

    public static String getUserHomeFolderName(String username) {
        return strategy.getUserHomeFolderName(username);
    }

    public static String getPublicFolderPath() {
        return strategy.getPublicFolderPath();
    }

    public static String getHomeFolderPath() {
        return strategy.getHomeFolderPath();
    }

    public static String getUserHomeFolderPath(String username) {
        return strategy.getUserHomeFolderPath(username);
    }

    public static String getRootFolderPath() {
        return strategy.getRootFolderPath();
    }

    public static String getEtcFolderPath() {
        return strategy.getEtcFolderPath();
    }

    public static String getEtcFolderName() {
        return strategy.getEtcFolderName();
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = DEFAULT;
        }
        if (strategyName.equals(DEFAULT)) {
            strategy = new DefaultClientRepositoryPathsStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (IClientRepositoryPathsStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)("ClientRepositoryPaths initialized: strategy=" + strategyName));
    }

    public static void setStrategyName(String strategyName) {
        ClientRepositoryPaths.strategyName = strategyName;
        ClientRepositoryPaths.initialize();
    }

    static {
        ClientRepositoryPaths.initialize();
    }
}

