/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;

public class RepositoryFileReader
extends InputStreamReader {
    protected static String getEncoding(RepositoryFile file) throws FileNotFoundException {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
        return fileData.getEncoding();
    }

    protected static String getEncoding(String path) throws FileNotFoundException {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile file = new RepositoryFileInputStream(path).getFile();
        SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
        return fileData.getEncoding();
    }

    protected static String getEncoding(Serializable id) throws FileNotFoundException {
        IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile file = new RepositoryFileInputStream(id).getFile();
        SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
        return fileData.getEncoding();
    }

    public RepositoryFileReader(String path) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new RepositoryFileInputStream(path), RepositoryFileReader.getEncoding(path));
    }

    public RepositoryFileReader(RepositoryFile file) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new RepositoryFileInputStream(file.getPath()), RepositoryFileReader.getEncoding(file.getPath()));
    }

    public RepositoryFileReader(Serializable id) throws FileNotFoundException, UnsupportedEncodingException {
        super((InputStream)new RepositoryFileInputStream(id), RepositoryFileReader.getEncoding(id));
    }
}

