/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr;

import java.io.IOException;
import java.security.AccessControlException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.repository2.messages.Messages;
import org.springframework.dao.DataAccessException;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;
import org.springframework.security.access.AccessDeniedException;

public class PentahoJcrTemplate
extends JcrTemplate {
    public Object execute(JcrCallback action, boolean exposeNativeSession) throws DataAccessException {
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionThreadBound((Session)session, (SessionFactory)this.getSessionFactory());
        try {
            Session sessionToExpose = exposeNativeSession ? session : this.createSessionProxy(session);
            Object result = action.doInJcr(sessionToExpose);
            return result;
        }
        catch (RepositoryException ex) {
            throw this.pentahoConvertJcrAccessException(ex);
        }
        catch (IOException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw this.pentahoConvertJcrAccessException(ex);
        }
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)this.isAllowCreate());
    }

    private RuntimeException pentahoConvertJcrAccessException(RuntimeException ex) {
        if (ex instanceof AccessControlException) {
            return new AccessDeniedException(Messages.getInstance().getString("PentahoJcrTemplate.ERROR_0001_ACCESS_DENIED"), (Throwable)ex);
        }
        return super.convertJcrAccessException(ex);
    }

    private RuntimeException pentahoConvertJcrAccessException(RepositoryException ex) {
        if (ex instanceof javax.jcr.AccessDeniedException) {
            return new AccessDeniedException(Messages.getInstance().getString("PentahoJcrTemplate.ERROR_0001_ACCESS_DENIED"), (Throwable)ex);
        }
        return super.convertJcrAccessException(ex);
    }
}

