/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userrole.ws;

import java.util.List;
import javax.jws.WebService;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.engine.security.userroledao.UserRoleInfo;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.security.userrole.ws.IUserRoleListWebService;

@WebService(endpointInterface="org.pentaho.platform.security.userrole.ws.IUserRoleListWebService", serviceName="userRoleListService", portName="userRoleListServicePort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class DefaultUserRoleListWebService
implements IUserRoleListWebService {
    private IUserRoleListService userRoleListService;

    public DefaultUserRoleListWebService() {
        this.userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        if (this.userRoleListService == null) {
            throw new IllegalStateException("no IUserRoleListService implementation");
        }
    }

    public DefaultUserRoleListWebService(IUserRoleListService userRoleListService) {
        this.userRoleListService = userRoleListService;
    }

    @Override
    public List<String> getAllRoles() {
        return this.userRoleListService.getAllRoles();
    }

    @Override
    public List<String> getAllUsers() {
        return this.userRoleListService.getAllUsers();
    }

    public List<String> getUsersInRole(String role) {
        return this.userRoleListService.getUsersInRole(null, role);
    }

    public List<String> getRolesForUser(String username) {
        return this.userRoleListService.getRolesForUser(null, username);
    }

    @Override
    public UserRoleInfo getUserRoleInfo() {
        UserRoleInfo userRoleInfo = new UserRoleInfo();
        userRoleInfo.setRoles(this.getAllRoles());
        userRoleInfo.setUsers(this.getAllUsers());
        return userRoleInfo;
    }

    @Override
    public List<String> getAllRolesForTenant(Tenant tenant) {
        return this.userRoleListService.getAllRoles((ITenant)tenant);
    }

    @Override
    public List<String> getAllUsersForTenant(Tenant tenant) {
        return this.userRoleListService.getAllUsers((ITenant)tenant);
    }
}

