/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CacheKey
implements Serializable {
    private static final long serialVersionUID = -1273843592305584696L;
    private ArrayList<KeyValuePair> keyValuePairs = new ArrayList();

    public CacheKey() {
    }

    public CacheKey(String key, String value) {
        this.addKeyValuePair(key, value);
    }

    public ArrayList<KeyValuePair> getKeyValuePairs() {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new ArrayList();
        }
        return this.keyValuePairs;
    }

    public void addKeyValuePair(String key, String value) {
        if (!StringUtils.isEmpty((String)key) && this.getByKey(key) == null) {
            this.getKeyValuePairs().add(new KeyValuePair(key, value));
        }
    }

    public void removeByKey(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            for (KeyValuePair pair : this.getKeyValuePairs()) {
                if (!key.equals(pair.getKey())) continue;
                this.getKeyValuePairs().remove(pair);
            }
        }
    }

    public KeyValuePair getByKey(String key) {
        if (!StringUtils.isEmpty((String)key)) {
            for (KeyValuePair pair : this.getKeyValuePairs()) {
                if (!key.equals(pair.getKey())) continue;
                return pair;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)o;
        return !(this.keyValuePairs != null ? !this.keyValuePairs.equals(other.keyValuePairs) : other.keyValuePairs != null);
    }

    public int hashCode() {
        int result = 7;
        for (KeyValuePair pair : this.getKeyValuePairs()) {
            result = 7 * result + (pair != null ? pair.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (KeyValuePair pair : this.getKeyValuePairs()) {
            sb.append(pair != null ? pair.toString() : "null");
        }
        return CacheKey.class.getName() + " [" + this.hashCode() + "]\n" + sb.toString();
    }

    public CacheKey clone() {
        CacheKey clone = new CacheKey();
        for (KeyValuePair pair : this.getKeyValuePairs()) {
            clone.addKeyValuePair(pair.getKey(), pair.getValue());
        }
        return clone;
    }

    public class KeyValuePair
    implements Serializable {
        private static final long serialVersionUID = -6692451693938049364L;
        private String key;
        private String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair other = (KeyValuePair)o;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.getClass().getName() + " [" + this.hashCode() + "]\n\tKey:[" + this.getKey() + "]\n\tValue:[" + this.getValue() + "]\n";
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.key = (String)in.readObject();
            this.value = (String)in.readObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.key);
            out.writeObject(this.value);
        }
    }
}

