/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.dataservices;

import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.WrappingFormulaContext;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.dataservices.DataservicesConnectionInfo;
import pt.webdetails.cda.connections.dataservices.IDataservicesLocalConnection;
import pt.webdetails.cda.dataaccess.InvalidParameterException;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.utils.Util;

public class DataservicesConnection
extends AbstractConnection {
    private static final Log logger = LogFactory.getLog(DataservicesConnection.class);
    public static final String TYPE = "dataservices";
    private DataservicesConnectionInfo connectionInfo;

    public DataservicesConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public DataservicesConnection() {
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.DATASERVICES;
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new DataservicesConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public ConnectionProvider getInitializedConnectionProvider(Map<String, String> dataserviceParameters) throws InvalidConnectionException {
        logger.debug((Object)"Creating new dataservices connection");
        IDataservicesLocalConnection dataservicesLocalConnection = CdaEngine.getEnvironment().getDataServicesLocalConnection();
        try {
            DriverConnectionProvider connectionProvider = dataservicesLocalConnection.getDriverConnectionProvider(dataserviceParameters);
            Properties properties = this.connectionInfo.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                connectionProvider.setProperty(key, value);
            }
            logger.debug((Object)"Opening connection");
            Connection connection = connectionProvider.createConnection(null, null);
            connection.close();
            logger.debug((Object)"Connection opened");
            return connectionProvider;
        }
        catch (MalformedURLException e) {
            throw new InvalidConnectionException("DataservicesConnection: Found MalformedURLException: " + Util.getExceptionDescription(e), e);
        }
        catch (SQLException e) {
            throw new InvalidConnectionException("DataservicesConnection: Found SQLException: " + Util.getExceptionDescription(e), e);
        }
    }

    public ConnectionProvider getInitializedConnectionProvider(ParameterDataRow parameterDataRow, FormulaContext formulaContext) throws InvalidConnectionException {
        try {
            Map<String, String> paramValues = this.getParameterValues(parameterDataRow, formulaContext);
            return this.getInitializedConnectionProvider(paramValues);
        }
        catch (EvaluationException | ParseException | InvalidParameterException | QueryException e) {
            throw new InvalidConnectionException("Error when creating the connection from the parameters", (Exception)e);
        }
    }

    private Map<String, String> getParameterValues(ParameterDataRow parameterDataRow, FormulaContext formulaContext) throws InvalidParameterException, QueryException, EvaluationException, ParseException {
        WrappingFormulaContext wrappedContext = new WrappingFormulaContext(formulaContext, (DataRow)parameterDataRow);
        TreeMap<String, String> parametersValues = new TreeMap<String, String>();
        FormulaParameter[] definedVariableNames = FormulaParameter.convert((ParameterMapping[])this.getConnectionInfo().getDefinedVariableNames());
        for (int i = 0; i < definedVariableNames.length; ++i) {
            FormulaParameter mapping = definedVariableNames[i];
            String sourceName = mapping.getName();
            Object value = mapping.compute((FormulaContext)wrappedContext);
            if (value != null) {
                parametersValues.put(sourceName, String.valueOf(value));
                continue;
            }
            parametersValues.put(sourceName, null);
        }
        return parametersValues;
    }

    @Override
    public List<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("variables", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getTypeForFile() {
        return "dataservices.dataservices";
    }

    public DataservicesConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataservicesConnection that = (DataservicesConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }
}

