/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.mondrian.IMondrianRoleMapper;
import pt.webdetails.cda.connections.mondrian.MondrianConnection;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;

public abstract class AbstractMondrianConnection
extends AbstractConnection
implements MondrianConnection {
    private static final Log logger = LogFactory.getLog(AbstractMondrianConnection.class);

    public AbstractMondrianConnection() {
    }

    public AbstractMondrianConnection(String id) {
        super(id);
    }

    public AbstractMondrianConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.MDX;
    }

    public ArrayList<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("catalog", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    protected String assembleRole(String catalog) {
        IMondrianRoleMapper roleMapper = CdaEngine.getEnvironment().getMondrianRoleMapper();
        try {
            if (roleMapper != null) {
                return roleMapper.getRoles(catalog);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error assembling role for mondrian connection", (Throwable)e);
        }
        return "";
    }
}

