/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.olap4j;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.dom4j.Element;
import org.olap4j.OlapConnection;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.olap4j.Olap4JConnection;
import pt.webdetails.cda.connections.olap4j.Olap4jConnectionInfo;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.utils.Util;

public class DefaultOlap4jConnection
extends AbstractConnection
implements Olap4JConnection {
    private Olap4jConnectionInfo connectionInfo;

    public DefaultOlap4jConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public DefaultOlap4jConnection(String id, Olap4jConnectionInfo info) {
        super(id);
        this.connectionInfo = info;
    }

    public DefaultOlap4jConnection() {
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new Olap4jConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return "olap4j";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOlap4jConnection that = (DefaultOlap4jConnection)o;
        return this.connectionInfo.equals(that.connectionInfo);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo.hashCode();
    }

    @Override
    public OlapConnectionProvider getInitializedConnectionProvider() throws InvalidConnectionException {
        DriverConnectionProvider connectionProvider = new DriverConnectionProvider();
        connectionProvider.setDriver(this.connectionInfo.getDriver());
        connectionProvider.setUrl(this.connectionInfo.getUrl());
        Properties properties = this.connectionInfo.getProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            connectionProvider.setProperty(key, value);
        }
        try {
            OlapConnection connection = connectionProvider.createConnection(this.connectionInfo.getUser(), this.connectionInfo.getPass());
            connection.close();
        }
        catch (SQLException e) {
            throw new InvalidConnectionException("JdbcConnection: Found SQLException: " + Util.getExceptionDescription(e), e);
        }
        return connectionProvider;
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.OLAP4J;
    }

    public ArrayList<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("driver", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("url", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("role", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("property", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getRoleField() {
        return this.connectionInfo.getRoleField();
    }

    @Override
    public String getUserField() {
        return this.connectionInfo.getUserField();
    }

    @Override
    public String getPasswordField() {
        return this.connectionInfo.getPasswordField();
    }

    public Olap4jConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public String getUrl() {
        return this.connectionInfo.getUrl();
    }

    @Override
    public String getDriver() {
        return this.connectionInfo.getDriver();
    }

    @Override
    public String getUser() {
        return this.connectionInfo.getUser();
    }

    @Override
    public String getPass() {
        return this.connectionInfo.getPass();
    }

    @Override
    public String getRole() {
        return this.connectionInfo.getRole();
    }
}

