/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.olap4j;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Olap4jConnectionInfo {
    private String driver;
    private String url;
    private String user;
    private String pass;
    private String role;
    private Properties properties;
    private String roleField;
    private String userField;
    private String passwordField;

    public Olap4jConnectionInfo(String driver, String url, String user, String password, String role, Properties properties, String roleField, String userField, String passField) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.pass = password;
        this.role = role;
        this.properties = properties;
        this.roleField = roleField;
        this.userField = userField;
        this.passwordField = passField;
    }

    public Olap4jConnectionInfo(Element connection) {
        String driver = (String)connection.selectObject("string(./Driver)");
        String url = (String)connection.selectObject("string(./Url)");
        String userName = (String)connection.selectObject("string(./User)");
        String password = (String)connection.selectObject("string(./Pass)");
        String role = (String)connection.selectObject("string(./Role)");
        String roleFormula = (String)connection.selectObject("string(./RoleField)");
        String userFormula = (String)connection.selectObject("string(./UserField)");
        String passFormula = (String)connection.selectObject("string(./PassField)");
        if (StringUtils.isEmpty((String)driver)) {
            throw new IllegalStateException("A driver is mandatory");
        }
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalStateException("A url is mandatory");
        }
        this.url = url;
        this.driver = driver;
        if (!StringUtils.isEmpty((String)userName)) {
            this.setUser(userName);
        }
        if (!StringUtils.isEmpty((String)password)) {
            this.setPass(password);
        }
        if (!StringUtils.isEmpty((String)role)) {
            this.setRole(role);
        }
        if (!StringUtils.isEmpty((String)userFormula)) {
            this.setUserField(userFormula);
        }
        if (!StringUtils.isEmpty((String)passFormula)) {
            this.setPasswordField(passFormula);
        }
        if (!StringUtils.isEmpty((String)roleFormula)) {
            this.setRoleField(roleFormula);
        }
        this.properties = new Properties();
        List list = connection.elements("Property");
        for (Element childElement : list) {
            String name = childElement.attributeValue("name");
            String text = childElement.getText();
            this.properties.put(name, text);
        }
    }

    public String getRoleField() {
        return this.roleField;
    }

    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Olap4jConnectionInfo that = (Olap4jConnectionInfo)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.pass != null ? !this.pass.equals(that.pass) : that.pass != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.driver != null ? this.driver.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.pass != null ? this.pass.hashCode() : 0);
        return result;
    }
}

