/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.scripting;

import java.util.ArrayList;
import org.dom4j.Element;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.scripting.ScriptingConnectionInfo;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;

public class ScriptingConnection
extends AbstractConnection {
    private ScriptingConnectionInfo connectionInfo;

    public ScriptingConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public ScriptingConnection() {
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new ScriptingConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return "scripting";
    }

    @Deprecated
    public ScriptingConnectionInfo getScriptingConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptingConnection that = (ScriptingConnection)o;
        return this.connectionInfo.equals(that.connectionInfo);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo.hashCode();
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.SCRIPTING;
    }

    public ArrayList<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("language", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("initscript", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    public ScriptingConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

