/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.xpath;

import java.util.ArrayList;
import org.dom4j.Element;
import pt.webdetails.cda.connections.AbstractConnection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.xpath.XPathConnectionInfo;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;

public class XPathConnection
extends AbstractConnection {
    private XPathConnectionInfo connectionInfo;

    public XPathConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public XPathConnection() {
    }

    @Override
    public ConnectionCatalog.ConnectionType getGenericType() {
        return ConnectionCatalog.ConnectionType.XPATH;
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new XPathConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return "xPath";
    }

    public String getXqueryDataFile() {
        if (this.connectionInfo == null) {
            throw new IllegalStateException();
        }
        return this.connectionInfo.getXqueryDataFile();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPathConnection that = (XPathConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }

    public ArrayList<PropertyDescriptor> getProperties() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("dataFile", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getTypeForFile() {
        return "xpath.xPath";
    }

    public XPathConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

