/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.libraries.base.config.Configuration;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.cache.DataAccessCacheElementParser;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.DataAccessConnectionDescriptor;
import pt.webdetails.cda.dataaccess.DataAccessEnums;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cda.utils.FormulaEvaluator;
import pt.webdetails.cda.utils.InvalidOutputIndexException;
import pt.webdetails.cda.utils.TableModelUtils;
import pt.webdetails.cda.utils.Util;
import pt.webdetails.cda.utils.kettle.SortException;

public abstract class AbstractDataAccess
implements DataAccess {
    private static final Log logger = LogFactory.getLog(AbstractDataAccess.class);
    private static IQueryCache cache;
    private CdaSettings cdaSettings;
    private String id;
    private String name;
    private DataAccessEnums.ACCESS_TYPE access = DataAccessEnums.ACCESS_TYPE.PUBLIC;
    private boolean cacheEnabled = false;
    private int cacheDuration = 3600;
    private ArrayList<Parameter> parameters;
    private HashMap<Integer, DataAccess.OutputMode> outputMode;
    private HashMap<Integer, ArrayList<Integer>> outputs;
    private ArrayList<ColumnDefinition> columnDefinitions;
    protected HashMap<Integer, ColumnDefinition> columnDefinitionIndexMap;
    private DataAccessCacheElementParser cdaCacheParser;
    private static final String PARAM_ITERATOR_BEGIN = "$FOREACH(";
    private static final String PARAM_ITERATOR_END = ")";
    private static final String PARAM_ITERATOR_ARG_SEPARATOR = ",";
    private static final String EXTRA_CACHE_KEYS_PROPERTY = "pt.webdetails.cda.cache.extraCacheKeys";

    protected AbstractDataAccess() {
    }

    protected AbstractDataAccess(Element element) {
        this.name = "";
        this.columnDefinitionIndexMap = new HashMap();
        this.columnDefinitions = new ArrayList();
        this.parameters = new ArrayList();
        this.outputs = new HashMap();
        this.outputs.put(1, new ArrayList());
        this.outputMode = new HashMap();
        this.outputMode.put(1, DataAccess.OutputMode.INCLUDE);
        this.parseOptions(element);
    }

    protected AbstractDataAccess(String id, String name) {
        this.name = name;
        this.id = id;
        this.columnDefinitionIndexMap = new HashMap();
        this.columnDefinitions = new ArrayList();
        this.parameters = new ArrayList();
        this.outputs = new HashMap();
        this.outputs.put(1, new ArrayList());
        this.outputMode = new HashMap();
        this.outputMode.put(1, DataAccess.OutputMode.INCLUDE);
    }

    public void setParameters(Collection<Parameter> params) {
        this.parameters.clear();
        this.parameters.addAll(params);
    }

    @Override
    public abstract String getType();

    private void parseOptions(Element element) {
        this.id = element.attributeValue("id");
        Element nameElement = (Element)element.selectSingleNode("./Name");
        if (nameElement != null) {
            this.name = nameElement.getTextTrim();
        }
        if (element.attributeValue("access") != null && element.attributeValue("access").equals("private")) {
            this.access = DataAccessEnums.ACCESS_TYPE.PRIVATE;
        }
        if (element.attributeValue("cache") != null && element.attributeValue("cache").equals("true")) {
            this.cacheEnabled = true;
        }
        if (element.attribute("cacheDuration") != null && !element.attribute("cacheDuration").toString().equals("")) {
            this.cacheDuration = Integer.parseInt(element.attributeValue("cacheDuration"));
        }
        List<Element> parameterNodes = Util.selectElements(element, "Parameters/Parameter");
        for (Element element2 : parameterNodes) {
            this.parameters.add(new Parameter(element2));
        }
        List<Element> outputNodes = Util.selectElements(element, "Output");
        for (Element element3 : outputNodes) {
            String[] indexes;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (element3 == null) continue;
            int localId = 1;
            localId = element3.attribute("id") != null && !element3.attribute("id").toString().equals("") ? Integer.parseInt(element3.attributeValue("id")) : 1;
            try {
                this.outputMode.put(localId, DataAccess.OutputMode.valueOf(element3.attributeValue("mode").toUpperCase()));
            }
            catch (Exception e) {
                this.outputMode.put(localId, DataAccess.OutputMode.INCLUDE);
            }
            for (String index : indexes = element3.attributeValue("indexes").split(PARAM_ITERATOR_ARG_SEPARATOR)) {
                arrayList.add(Integer.parseInt(index));
            }
            this.outputs.put(localId, arrayList);
        }
        List<Element> list = Util.selectElements(element, "Columns/*");
        for (Element element4 : list) {
            this.columnDefinitions.add(new ColumnDefinition(element4));
        }
        ArrayList<ColumnDefinition> arrayList = this.getColumns();
        for (ColumnDefinition columnDefinition : arrayList) {
            this.columnDefinitionIndexMap.put(columnDefinition.getIndex(), columnDefinition);
        }
        Element element5 = (Element)element.selectSingleNode("Cache");
        if (element5 != null) {
            this.cdaCacheParser = new DataAccessCacheElementParser(element5);
            if (this.cdaCacheParser.parseParameters()) {
                this.setCacheEnabled(this.cdaCacheParser.isCacheEnabled());
                if (this.cdaCacheParser.getCacheDuration() != null) {
                    this.setCacheDuration(this.cdaCacheParser.getCacheDuration());
                }
            }
        }
    }

    public static synchronized IQueryCache getCdaCache() {
        if (cache == null) {
            try {
                cache = CdaEngine.getEnvironment().getQueryCache();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return cache;
    }

    public static synchronized void shutdownCache() {
        if (cache != null) {
            cache.shutdownIfRunning();
            cache = null;
        }
    }

    public static synchronized void clearCache() {
        IQueryCache cache = AbstractDataAccess.getCdaCache();
        cache.clearCache();
    }

    @Override
    public TableModel doQuery(QueryOptions queryOptions) throws QueryException {
        Map<String, Iterable<String>> iterableParameters = this.getIterableParametersValues(queryOptions);
        if (!iterableParameters.isEmpty()) {
            return this.doQueryOnIterableParameters(queryOptions, iterableParameters);
        }
        TableModel tableModel = this.queryDataSource(queryOptions);
        try {
            TableModel outputTableModel = TableModelUtils.postProcessTableModel(this, queryOptions, tableModel);
            logger.debug((Object)("Query " + this.getId() + " done successfully - returning tableModel"));
            return outputTableModel;
        }
        catch (InvalidOutputIndexException e) {
            throw new QueryException("Error while setting output index id ", e);
        }
        catch (SortException e) {
            throw new QueryException("Error while sorting output ", e);
        }
    }

    @Override
    public TableModel listParameters() {
        return TableModelUtils.dataAccessParametersToTableModel(this.getParameters());
    }

    protected abstract TableModel queryDataSource(QueryOptions var1) throws QueryException;

    public ArrayList<ColumnDefinition> getColumns() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (definition.getType() != ColumnDefinition.TYPE.COLUMN) continue;
            list.add(definition);
        }
        return list;
    }

    @Override
    public ColumnDefinition getColumnDefinition(int idx) {
        return this.columnDefinitionIndexMap.get(new Integer(idx));
    }

    @Override
    public ArrayList<ColumnDefinition> getCalculatedColumns() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (definition.getType() != ColumnDefinition.TYPE.CALCULATED_COLUMN) continue;
            list.add(definition);
        }
        return list;
    }

    @Override
    public void storeDescriptor(DataAccessConnectionDescriptor descriptor) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DataAccessEnums.ACCESS_TYPE getAccess() {
        return this.access;
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        this.cacheEnabled = enabled;
    }

    @Override
    public int getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(int cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    @Override
    public CdaSettings getCdaSettings() {
        return this.cdaSettings;
    }

    @Override
    public void setCdaSettings(CdaSettings cdaSettings) {
        this.cdaSettings = cdaSettings;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public ArrayList<Integer> getOutputs() {
        if (this.outputs.isEmpty()) {
            return new ArrayList<Integer>();
        }
        return this.outputs.get(1);
    }

    @Override
    public ArrayList<Integer> getOutputs(int id) {
        return this.outputs.get(id);
    }

    public void setOutputs(HashMap<Integer, ArrayList<Integer>> outputIndexes) {
        this.outputs = outputIndexes;
    }

    @Override
    public DataAccess.OutputMode getOutputMode() {
        return this.outputMode.get(1);
    }

    @Override
    public DataAccess.OutputMode getOutputMode(int id) {
        return this.outputMode.get(id);
    }

    public List<DataAccessConnectionDescriptor> getDataAccessConnectionDescriptors() {
        return this.getDataAccessConnectionDescriptors();
    }

    public List<PropertyDescriptor> getInterface() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("access", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("parameters", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("output", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("columns", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    public abstract ConnectionCatalog.ConnectionType getConnectionType();

    public Connection[] getAvailableConnections() {
        return ConnectionCatalog.getInstance(false).getConnectionsByType(this.getConnectionType());
    }

    public Connection[] getAvailableConnections(boolean skipCache) {
        return ConnectionCatalog.getInstance(skipCache).getConnectionsByType(this.getConnectionType());
    }

    public String getTypeForFile() {
        return this.getClass().toString().toLowerCase().replaceAll("class pt.webdetails.cda.dataaccess.(.*)connection", "$1");
    }

    @Override
    public boolean hasIterableParameterValues(QueryOptions queryOptions) throws QueryException {
        for (Parameter param : queryOptions.getParameters()) {
            String value = param.getStringValue();
            if (value == null || !value.startsWith(PARAM_ITERATOR_BEGIN)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Iterable<String>> getIterableParametersValues(QueryOptions queryOptions) throws QueryException {
        HashMap<String, Iterable<String>> iterableParameters = new HashMap<String, Iterable<String>>();
        String splitRegex = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
        for (Parameter param : queryOptions.getParameters()) {
            Iterable<String> paramValues;
            String value = param.getStringValue();
            if (value == null || !value.startsWith(PARAM_ITERATOR_BEGIN)) continue;
            String[] args = Util.getContentsBetween(value, PARAM_ITERATOR_BEGIN, PARAM_ITERATOR_END).split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            if (args.length < 2) {
                throw new QueryException("Parameter '" + param.getName() + "': Error iterating parameter.", new IllegalArgumentException("$FOREACH: need at least dataAccessId and column index"));
            }
            String dataAccessId = StringUtils.trim((String)args[0]);
            try {
                this.getCdaSettings().getDataAccess(dataAccessId);
            }
            catch (UnknownDataAccessException e) {
                throw new QueryException("$FOREACH: Invalid dataAccessId.", e);
            }
            int columnIdx = 0;
            try {
                columnIdx = Integer.parseInt(StringUtils.trim((String)args[1]));
            }
            catch (NumberFormatException nfe) {
                throw new QueryException("$FOREACH: Unable to parse 2nd argument.", nfe);
            }
            String[] dataAccessParams = null;
            if (args.length > 2) {
                dataAccessParams = new String[args.length - 2];
                System.arraycopy(args, 2, dataAccessParams, 0, dataAccessParams.length);
            }
            if ((paramValues = this.expandParameterIteration(dataAccessId, columnIdx, dataAccessParams)) == null) {
                param.setValue(null);
                continue;
            }
            iterableParameters.put(param.getName(), paramValues);
        }
        return iterableParameters;
    }

    private Iterable<String> expandParameterIteration(String dataAccessId, int outColumnIdx, String[] dataAccessParameters) throws QueryException {
        String EXC_TEXT = "Unable to expand parameter iteration. ";
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataAccessId(dataAccessId);
        if (dataAccessParameters != null) {
            for (String paramDef : dataAccessParameters) {
                int attribIdx = StringUtils.indexOf((String)paramDef, (char)'=');
                if (attribIdx > 0) {
                    String paramName = StringUtils.trim((String)StringUtils.substring((String)paramDef, (int)0, (int)attribIdx));
                    String paramValue = StringUtils.trim((String)StringUtils.substring((String)paramDef, (int)(attribIdx + 1)));
                    queryOptions.addParameter(paramName, paramValue);
                    continue;
                }
                logger.error((Object)("Bad parameter definition, skipping: " + paramDef));
            }
        }
        logger.debug((Object)("expandParameterIteration: Doing inner query on CdaSettings [ " + this.cdaSettings.getId() + " (" + queryOptions.getDataAccessId() + ")]"));
        try {
            DataAccess dataAccess = this.getCdaSettings().getDataAccess(queryOptions.getDataAccessId());
            TableModel tableModel = dataAccess.doQuery(queryOptions);
            if (outColumnIdx < 0 || outColumnIdx >= tableModel.getColumnCount()) {
                throw new QueryException("Unable to expand parameter iteration. ", new IllegalArgumentException("Output column index " + outColumnIdx + " out of range."));
            }
            if (tableModel.getRowCount() < 1) {
                return null;
            }
            return new StringColumnIterable(tableModel, outColumnIdx);
        }
        catch (UnknownDataAccessException e) {
            throw new QueryException("Unable to expand parameter iteration. ", e);
        }
    }

    private TableModel doQueryOnIterableParameters(QueryOptions queryOptions, Map<String, Iterable<String>> iterableParameters) throws QueryException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList iterators = new ArrayList();
        ArrayList<Iterable<String>> iterables = new ArrayList<Iterable<String>>();
        ArrayList values = new ArrayList();
        TableModel result = null;
        try {
            int paramCount = 0;
            for (String name : iterableParameters.keySet()) {
                names.add(name);
                iterables.add(iterableParameters.get(name));
                iterators.add(((Iterable)iterables.get(paramCount)).iterator());
                values.add(((Iterator)iterators.get(paramCount)).next());
                ++paramCount;
            }
            boolean exhausted = false;
            block3: while (!exhausted) {
                TableModel tableModel;
                for (int i = 0; i < paramCount; ++i) {
                    queryOptions.setParameter((String)names.get(i), (String)values.get(i));
                }
                result = tableModel = this.doQuery(queryOptions);
                for (int i = 0; i < paramCount; ++i) {
                    if (((Iterator)iterators.get(i)).hasNext()) {
                        values.set(i, ((Iterator)iterators.get(i)).next());
                        continue block3;
                    }
                    if (i < paramCount - 1) {
                        iterators.set(i, ((Iterable)iterables.get(i)).iterator());
                        values.set(i, ((Iterator)iterators.get(i)).next());
                        continue;
                    }
                    exhausted = true;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public ArrayList<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public Serializable getCacheKey() {
        String cacheKeyInfo = "Getting Cache Key for file: " + this.getCdaSettings().getId() + ", DataAccessID: " + this.getId() + "\n";
        CacheKey systemWideCacheKey = this.getSystemCacheKeys();
        if (this.cdaCacheParser != null && this.cdaCacheParser.parseKeys()) {
            CacheKey mergedCacheKey = this.mergeCacheKeys(this.cdaCacheParser.getCacheKey(), systemWideCacheKey);
            if (mergedCacheKey.getKeyValuePairs().size() > 0) {
                cacheKeyInfo = cacheKeyInfo + mergedCacheKey.toString();
            }
            logger.info((Object)cacheKeyInfo);
            return mergedCacheKey;
        }
        if (systemWideCacheKey.getKeyValuePairs().size() > 0) {
            cacheKeyInfo = cacheKeyInfo + systemWideCacheKey.toString();
        }
        logger.info((Object)cacheKeyInfo);
        return systemWideCacheKey;
    }

    public CacheKey getSystemCacheKeys() {
        Configuration config = CdaEngine.getEnvironment().getBaseConfig();
        Iterator extraCacheKeys = config.findPropertyKeys(EXTRA_CACHE_KEYS_PROPERTY);
        CacheKey cacheKey = new CacheKey();
        while (extraCacheKeys.hasNext()) {
            String key = (String)extraCacheKeys.next();
            cacheKey.addKeyValuePair(key.replace("pt.webdetails.cda.cache.extraCacheKeys.", ""), FormulaEvaluator.replaceFormula(config.getConfigProperty(key)));
        }
        return cacheKey;
    }

    private CacheKey mergeCacheKeys(CacheKey cacheKey1, CacheKey cacheKey2) {
        ArrayList<CacheKey.KeyValuePair> pairs = cacheKey2.getKeyValuePairs();
        for (CacheKey.KeyValuePair pair : pairs) {
            cacheKey1.addKeyValuePair(pair.getKey(), pair.getValue());
        }
        return cacheKey1;
    }

    protected Serializable getExtraCacheKey() {
        return this.getCacheKey();
    }

    private class StringColumnIterable
    implements Iterable<String> {
        private final TableModel table;
        private final int columnIndex;

        public StringColumnIterable(TableModel tableModel, int columnIndex) {
            this.table = tableModel;
            this.columnIndex = columnIndex;
        }

        @Override
        public Iterator<String> iterator() {
            return new StringColumnIterator();
        }

        private class StringColumnIterator
        implements Iterator<String> {
            int rowIndex = 0;

            private StringColumnIterator() {
            }

            @Override
            public boolean hasNext() {
                return StringColumnIterable.this.table.getRowCount() > this.rowIndex;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringColumnIterable.this.table.getValueAt(this.rowIndex++, StringColumnIterable.this.columnIndex).toString();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

