/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.settings.SettingsManager;

public class DataAccessConnectionDescriptor {
    private static final Log logger = LogFactory.getLog(SettingsManager.class);
    private String name;
    private Connection conn;
    private AbstractDataAccess dataAccess;

    public DataAccessConnectionDescriptor() {
    }

    public DataAccessConnectionDescriptor(String name) {
        this();
        this.setName(name);
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setDataAccess(AbstractDataAccess da) {
        this.dataAccess = da;
    }

    public ArrayList<PropertyDescriptor> getDescriptors() {
        ArrayList<PropertyDescriptor> collapsedInfo = new ArrayList<PropertyDescriptor>();
        collapsedInfo.addAll(this.conn.getProperties());
        collapsedInfo.addAll(this.dataAccess.getInterface());
        return collapsedInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toJSON() {
        List<PropertyDescriptor> dataAccessInfo = this.dataAccess.getInterface();
        List<PropertyDescriptor> connectionInfo = this.conn.getProperties();
        StringBuilder output = new StringBuilder();
        if (dataAccessInfo.size() > 0) {
            output.append("\"" + this.name + "\": {\n");
            output.append("\t\"metadata\": {\n");
            output.append("\t\t\"name\": \"" + this.dataAccess.getLabel() + (this.conn.getGenericType() != ConnectionCatalog.ConnectionType.NONE ? " over " + this.conn.getType() : "") + "\",\n");
            output.append(this.conn.getGenericType() != ConnectionCatalog.ConnectionType.NONE ? "\t\t\"conntype\": \"" + this.conn.getTypeForFile() + "\",\n" : "");
            output.append("\t\t\"datype\": \"" + this.dataAccess.getType() + "\",\n");
            output.append("\t\t\"group\": \"" + this.conn.getGenericType().toString() + "\",\n");
            output.append("\t\t\"groupdesc\": \"" + (this.conn.getGenericType() != ConnectionCatalog.ConnectionType.NONE ? this.conn.getGenericType().toString() : "Compound") + " Queries\",\n");
            output.append("\t},\n");
            output.append("\t\"definition\": {\n");
            if (connectionInfo.size() > 0) {
                output.append("\t\t\"connection\": {\n");
                for (PropertyDescriptor prop : connectionInfo) {
                    output.append("\t\t\t\"" + prop.getName() + "\": {\"type\": \"" + (Object)((Object)prop.getType()) + "\", \"placement\": \"" + (Object)((Object)prop.getPlacement()) + "\"},\n");
                }
                output.append("\t\t},\n");
            }
            output.append("\t\t\"dataaccess\": {\n");
            for (PropertyDescriptor prop : dataAccessInfo) {
                output.append("\t\t\t\"" + prop.getName() + "\": {\"type\": \"" + (Object)((Object)prop.getType()) + "\", \"placement\": \"" + (Object)((Object)prop.getPlacement()) + "\"},\n");
            }
            output.append("\t\t}\n\t}\n}");
        }
        return output.toString().replaceAll(",\n(\t*)}", "\n$1}");
    }

    public static DataAccessConnectionDescriptor[] fromClass(Class<? extends DataAccess> dataAccess) throws Exception {
        ArrayList<DataAccessConnectionDescriptor> descriptors = new ArrayList<DataAccessConnectionDescriptor>();
        AbstractDataAccess sample = (AbstractDataAccess)dataAccess.newInstance();
        Connection[] conns = sample.getAvailableConnections();
        if (conns.length > 0) {
            for (Connection conn : conns) {
                try {
                    String name = sample.getType() + (!conn.getGenericType().equals((Object)ConnectionCatalog.ConnectionType.NONE) ? "_" + conn.getType() : "");
                    DataAccessConnectionDescriptor descriptor = new DataAccessConnectionDescriptor(name);
                    descriptor.setDataAccess(sample);
                    descriptor.setConnection(conn);
                    descriptors.add(descriptor);
                }
                catch (UnsupportedOperationException e) {
                    logger.warn((Object)("Failed to generate a descriptor for " + sample.getType() + "_" + conn.getType()));
                }
            }
        }
        return descriptors.toArray(new DataAccessConnectionDescriptor[descriptors.size()]);
    }
}

