/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.connections.mondrian.AbstractMondrianConnection;
import pt.webdetails.cda.connections.mondrian.MondrianConnectionInfo;
import pt.webdetails.cda.dataaccess.GlobalMdxDataAccess;
import pt.webdetails.cda.utils.mondrian.ExtDenormalizedMDXDataFactory;

public class DenormalizedMdxDataAccess
extends GlobalMdxDataAccess {
    private static final Log logger = LogFactory.getLog(DenormalizedMdxDataAccess.class);

    public DenormalizedMdxDataAccess(Element element) {
        super(element);
    }

    public DenormalizedMdxDataAccess() {
    }

    @Override
    protected AbstractNamedMDXDataFactory createDataFactory() {
        return new ExtDenormalizedMDXDataFactory();
    }

    @Override
    public String getType() {
        return "denormalizedMdx";
    }

    @Override
    protected Serializable getExtraCacheKey() {
        MondrianConnectionInfo mci;
        try {
            mci = ((AbstractMondrianConnection)this.getCdaSettings().getConnection(this.getConnectionId())).getConnectionInfo();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get a connection info for cache key");
            mci = null;
        }
        CacheKey cacheKey = this.getCacheKey() != null ? ((CacheKey)this.getCacheKey()).clone() : new CacheKey();
        cacheKey.addKeyValuePair("roles", mci.getMondrianRole());
        return cacheKey;
    }

    protected static class ExtraCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String roles;

        public ExtraCacheKey(String roles) {
            this.roles = roles;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtraCacheKey other = (ExtraCacheKey)obj;
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.roles = (String)in.readObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.roles);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.roles != null ? this.roles.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.getClass().getName() + "[roles:" + this.roles + "]";
        }
    }
}

