/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.lang.reflect.Method;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathDataFactory;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.xpath.XPathConnection;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.SimpleDataAccess;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.utils.CdaPropertyLookupParser;

public class XPathDataAccess
extends PREDataAccess {
    private static final Log logger = LogFactory.getLog(XPathDataAccess.class);

    public XPathDataAccess(Element element) {
        super(element);
    }

    public XPathDataAccess() {
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        XPathConnection connection = (XPathConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        XPathDataFactory dataFactory = new XPathDataFactory();
        dataFactory.setXqueryDataFile(connection.getXqueryDataFile());
        XPathDataAccess.legacyFallbackInvoke(dataFactory, "setQuery", new Class[]{String.class, String.class}, new Object[]{"query", this.getQuery()}, new Class[]{String.class, String.class, Boolean.TYPE}, new Object[]{"query", this.getQuery(), true});
        return dataFactory;
    }

    private static boolean legacyFallbackInvoke(Object object, String methodName, Class<?>[] argTypes, Object[] args, Class<?>[] argTypesFallback, Object[] argsFallback) {
        Method method = null;
        try {
            try {
                method = object.getClass().getMethod(methodName, argTypes);
            }
            catch (NoSuchMethodException e1) {
                logger.debug((Object)String.format("failed to find %s(%s): ", methodName, ArrayUtils.toString(argTypes), e1.getLocalizedMessage()));
                try {
                    method = object.getClass().getMethod(methodName, argTypesFallback);
                    args = argsFallback;
                }
                catch (NoSuchMethodException e2) {
                    logger.error((Object)String.format("failed to find %1$s(%2$s) or %1$s(%3$s) ", methodName, ArrayUtils.toString(argTypes), ArrayUtils.toString(argTypesFallback)));
                    throw e2;
                }
            }
            method.invoke(object, args);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)String.format("%s call failed ", methodName), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getType() {
        return "xPath";
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.XPATH;
    }

    @Override
    protected SimpleDataAccess.IDataSourceQuery performRawQuery(ParameterDataRow parameterDataRow) throws QueryException {
        String origQuery = this.query;
        CdaPropertyLookupParser lookupParser = new CdaPropertyLookupParser((DataRow)parameterDataRow);
        this.query = lookupParser.translateAndLookup(this.query, (DataRow)parameterDataRow);
        SimpleDataAccess.IDataSourceQuery dataSourceQuery = super.performRawQuery(parameterDataRow);
        this.query = origQuery;
        return dataSourceQuery;
    }
}

