/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.endpoints;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import pt.webdetails.cda.CdaCoreService;
import pt.webdetails.cda.exporter.ExportOptions;
import pt.webdetails.cda.exporter.ExportedQueryResult;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.utils.DoQueryParameters;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="/cda/api/utils")
public class RestEndpoint {
    static final String PREFIX_PARAMETER = "param";
    static final String PREFIX_SETTING = "setting";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";

    private static String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    @POST
    @Path(value="/doQuery")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public Response doQueryPost(MultivaluedMap<String, String> formParameters) {
        try {
            DoQueryParameters queryParams = this.getQueryParameters(formParameters);
            return this.doQuery(queryParams);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    @GET
    @Path(value="/doQuery")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public Response doQueryGet(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="outputType") String outputType, @QueryParam(value="outputIndexId") Integer outputIndexId, @QueryParam(value="dataAccessId") String dataAccessId, @QueryParam(value="bypassCache") Boolean bypassCache, @QueryParam(value="paginateQuery") Boolean paginateQuery, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="pageStart") Integer pageStart, @QueryParam(value="wrapItUp") Boolean wrapItUp, @QueryParam(value="sortBy") List<String> sortBy, @QueryParam(value="jsonCallback") String jsonCallback, @Context HttpServletRequest request) {
        try {
            DoQueryParameters queryParams = this.getQueryParameters(path, solution, file, outputType, outputIndexId, dataAccessId, bypassCache, paginateQuery, pageSize, pageStart, wrapItUp, sortBy, jsonCallback, request);
            return this.doQuery(queryParams);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private Response doQuery(DoQueryParameters queryParameters) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        if (queryParameters.isWrapItUp()) {
            return this.buildOkResponse(coreService.wrapQuery(queryParameters));
        }
        return this.buildOkResponse(coreService.doQuery(queryParameters));
    }

    @GET
    @Path(value="/unwrapQuery")
    @Consumes(value={"application/xml", "application/json"})
    public Response unwrapQuery(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="uuid") String uuid) {
        try {
            DoQueryParameters parameters = this.getQueryParameters(path, solution, file);
            ExportedQueryResult result = this.unwrapQuery(parameters, uuid);
            return this.buildOkResponse(result);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private ExportedQueryResult unwrapQuery(DoQueryParameters parameters, String uuid) throws Exception {
        String cdaSettingsPath = parameters.getPath();
        CdaCoreService coreService = this.getCoreService();
        return coreService.unwrapQuery(cdaSettingsPath, uuid);
    }

    @GET
    @Path(value="/listQueries")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public Response listQueries(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="outputType") String outputType) {
        try {
            DoQueryParameters parameters = this.getQueryParameters(path, solution, file, outputType);
            ExportedQueryResult result = this.listQueries(parameters);
            return this.buildOkResponse(result);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private ExportedQueryResult listQueries(DoQueryParameters parameters) throws Exception {
        String cdaSettingsPath = parameters.getPath();
        ExportOptions exportOptions = this.getSimpleExportOptions(parameters.getOutputType());
        CdaCoreService coreService = this.getCoreService();
        return coreService.listQueries(cdaSettingsPath, exportOptions);
    }

    @GET
    @Path(value="/listParameters")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public Response listParameters(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="outputType") String outputType, @QueryParam(value="dataAccessId") String dataAccessId) {
        try {
            DoQueryParameters parameters = this.getQueryParameters(path, solution, file, outputType, dataAccessId);
            ExportedQueryResult result = this.listParameters(parameters);
            return this.buildOkResponse(result);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private ExportedQueryResult listParameters(DoQueryParameters queryParameters) throws Exception {
        String cdaSettingsPath = queryParameters.getPath();
        String dataAccessId = queryParameters.getDataAccessId();
        ExportOptions exportOptions = this.getSimpleExportOptions(queryParameters.getOutputType());
        CdaCoreService coreService = this.getCoreService();
        return coreService.listParameters(cdaSettingsPath, dataAccessId, exportOptions);
    }

    @GET
    @Path(value="/getCdaList")
    @Consumes(value={"application/xml", "application/json"})
    public Response getCdaList(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="outputType") String outputType) {
        try {
            DoQueryParameters queryParameters = this.getQueryParameters(path, solution, file, outputType);
            ExportedQueryResult cdaListResult = this.getCdaList(queryParameters);
            return this.buildOkResponse(cdaListResult);
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private ExportedQueryResult getCdaList(DoQueryParameters queryParameters) throws UnsupportedExporterException {
        ExportOptions exportOptions = this.getSimpleExportOptions(queryParameters.getOutputType());
        CdaCoreService coreService = this.getCoreService();
        return coreService.getCdaList(exportOptions);
    }

    private ExportOptions getSimpleExportOptions(final String outputType) {
        return new ExportOptions(){

            @Override
            public String getOutputType() {
                return outputType;
            }

            @Override
            public Map<String, String> getExtraSettings() {
                return Collections.emptyMap();
            }
        };
    }

    @GET
    @Path(value="/getCssResource")
    @Produces(value={"text/css"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getCssResource(@QueryParam(value="resource") String resource) {
        try {
            String cssResource = this.getResource(resource);
            return this.buildOkResponse(cssResource, "text/css");
        }
        catch (IOException ioe) {
            return this.buildServerErrorResponse();
        }
    }

    @GET
    @Path(value="/getJsResource")
    @Produces(value={"text/javascript"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getJsResource(@QueryParam(value="resource") String resource) {
        try {
            String jsResource = this.getResource(resource);
            return this.buildOkResponse(jsResource, "text/javascript");
        }
        catch (IOException ioe) {
            return this.buildServerErrorResponse();
        }
    }

    @GET
    @Path(value="/listDataAccessTypes")
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response listDataAccessTypes(@QueryParam(value="refreshCache") boolean refreshCache) {
        try {
            CdaCoreService coreService = this.getCoreService();
            String result = coreService.listDataAccessTypes(refreshCache);
            return this.buildOkResponse(result, "application/json");
        }
        catch (Exception ex) {
            return this.buildServerErrorResponse();
        }
    }

    private CdaCoreService getCoreService() {
        return new CdaCoreService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResource(String resource) throws IOException {
        IReadAccess repositoryAccess = this.getRepositoryAccess();
        if (!repositoryAccess.fileExists(resource)) {
            throw new FileNotFoundException("Resource '" + resource + "' not found.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream resourceInputStream = null;
        try {
            resourceInputStream = repositoryAccess.getFileInputStream(resource);
            IOUtils.copy((InputStream)resourceInputStream, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceInputStream);
        }
        return new String(out.toByteArray(), RestEndpoint.getEncoding());
    }

    private Response buildOkResponse(String result) {
        return this.buildOkResponse(result, "text/plain");
    }

    private Response buildOkResponse(String result, String contentType) {
        String contentTypeHeader = contentType + ";charset=" + RestEndpoint.getEncoding();
        return Response.ok((Object)result).header(HEADER_CONTENT_TYPE, (Object)contentTypeHeader).build();
    }

    private Response buildOkResponse(ExportedQueryResult result) throws ExporterException {
        String contentType = result.getContentType();
        String contentDisposition = result.getContentDisposition();
        return Response.ok((Object)result.asString()).header(HEADER_CONTENT_TYPE, (Object)contentType).header(HEADER_CONTENT_DISPOSITION, (Object)contentDisposition).build();
    }

    private Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    private IReadAccess getRepositoryAccess() {
        return PluginEnvironment.env().getContentAccessFactory().getUserContentAccess("/");
    }

    private DoQueryParameters getQueryParameters(String path, String solution, String file) {
        return this.getQueryParameters(path, solution, file, null, null);
    }

    private DoQueryParameters getQueryParameters(String path, String solution, String file, String outputType) {
        return this.getQueryParameters(path, solution, file, outputType, null);
    }

    private DoQueryParameters getQueryParameters(String path, String solution, String file, String outputType, String dataAccessId) {
        return this.getQueryParameters(path, solution, file, outputType, null, dataAccessId, null, null, null, null, null, null, null, null, null);
    }

    private DoQueryParameters getQueryParameters(MultivaluedMap<String, String> formParameters) {
        String path = (String)formParameters.getFirst((Object)"path");
        String solution = (String)formParameters.getFirst((Object)"solution");
        String file = (String)formParameters.getFirst((Object)"file");
        Boolean bypassCache = this.getFirstBoolean(formParameters, "bypassCache");
        Boolean paginateQuery = this.getFirstBoolean(formParameters, "paginateQuery");
        Boolean wrapItUp = this.getFirstBoolean(formParameters, "wrapItUp");
        Integer outputIndexId = this.getFirstInteger(formParameters, "outputIndexId");
        Integer pageSize = this.getFirstInteger(formParameters, "pageSize");
        Integer pageStart = this.getFirstInteger(formParameters, "pageStart");
        String outputType = (String)formParameters.getFirst((Object)"outputType");
        String dataAccessId = (String)formParameters.getFirst((Object)"dataAccessId");
        String jsonCallback = (String)formParameters.getFirst((Object)"jsonCallback");
        List sortBy = (List)formParameters.get((Object)"sortBy");
        Map<String, Object> extraParameters = this.getParameters(formParameters, PREFIX_PARAMETER);
        Map<String, Object> extraSettings = this.getParameters(formParameters, PREFIX_SETTING);
        return this.getQueryParameters(path, solution, file, outputType, outputIndexId, dataAccessId, bypassCache, paginateQuery, pageSize, pageStart, wrapItUp, sortBy, jsonCallback, extraParameters, extraSettings);
    }

    private DoQueryParameters getQueryParameters(String path, String solution, String file, String outputType, Integer outputIndexId, String dataAccessId, Boolean bypassCache, Boolean paginateQuery, Integer pageSize, Integer pageStart, Boolean wrapItUp, List<String> sortBy, String jsonCallback, HttpServletRequest request) {
        Map<String, Object> extraParameters = this.getParameters(request, PREFIX_PARAMETER);
        Map<String, Object> extraSettings = this.getParameters(request, PREFIX_SETTING);
        return this.getQueryParameters(path, solution, file, outputType, outputIndexId, dataAccessId, bypassCache, paginateQuery, pageSize, pageStart, wrapItUp, sortBy, jsonCallback, extraParameters, extraSettings);
    }

    private DoQueryParameters getQueryParameters(String path, String solution, String file, String outputType, Integer outputIndexId, String dataAccessId, Boolean bypassCache, Boolean paginateQuery, Integer pageSize, Integer pageStart, Boolean wrapItUp, List<String> sortBy, String jsonCallback, Map<String, Object> extraParameters, Map<String, Object> extraSettings) {
        DoQueryParameters queryParameters = new DoQueryParameters(path, solution, file);
        if (bypassCache != null) {
            queryParameters.setBypassCache(bypassCache);
        }
        if (dataAccessId != null) {
            queryParameters.setDataAccessId(dataAccessId);
        }
        if (outputIndexId != null) {
            queryParameters.setOutputIndexId(outputIndexId);
        }
        if (outputType != null) {
            queryParameters.setOutputType(outputType);
        }
        if (pageSize != null) {
            queryParameters.setPageSize(pageSize);
        }
        if (pageStart != null) {
            queryParameters.setPageStart(pageStart);
        }
        if (paginateQuery != null) {
            queryParameters.setPaginateQuery(paginateQuery);
        }
        if (sortBy != null && !sortBy.isEmpty()) {
            queryParameters.setSortBy(sortBy);
        }
        if (wrapItUp != null) {
            queryParameters.setWrapItUp(wrapItUp);
        }
        if (jsonCallback != null) {
            queryParameters.setJsonCallback(jsonCallback);
        }
        if (extraParameters != null && !extraParameters.isEmpty()) {
            queryParameters.setParameters(extraParameters);
        }
        if (extraSettings != null && !extraSettings.isEmpty()) {
            queryParameters.setExtraSettings(extraSettings);
        }
        return queryParameters;
    }

    private Boolean getFirstBoolean(MultivaluedMap<String, String> multivaluedMap, String key) {
        String value = (String)multivaluedMap.getFirst((Object)key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private Integer getFirstInteger(MultivaluedMap<String, String> multivaluedMap, String key) {
        String value = (String)multivaluedMap.getFirst((Object)key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    Map<String, Object> getParameters(MultivaluedMap<String, String> multivaluedMap, String parameterType) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        multivaluedMap.forEach((parameterName, parameterValueList) -> {
            if (parameterName.startsWith(parameterType)) {
                String[] parameterValues = parameterValueList.toArray(new String[0]);
                String name = parameterName.replaceFirst(parameterType, "");
                String[] value = parameterValues.length > 1 ? parameterValues : parameterValues[0];
                parameters.put(name, value);
            }
        });
        return parameters;
    }

    Map<String, Object> getParameters(HttpServletRequest request, String parameterType) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Map parameterMap = request.getParameterMap();
        parameterMap.forEach((parameterName, parameterValues) -> {
            if (parameterName.startsWith(parameterType)) {
                String name = parameterName.replaceFirst(parameterType, "");
                String[] value = ((String[])parameterValues).length > 1 ? parameterValues : parameterValues[0];
                parameters.put(name, value);
            }
        });
        return parameters;
    }
}

